/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.virusscan.VirusScanStatus;
import de.justsoftware.justdocumentz.virusscan.VirusScanStatusMessage;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanStatusPublisher;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "(Lorg/springframework/kafka/core/KafkaTemplate;)V", "getKafkaTemplate", "()Lorg/springframework/kafka/core/KafkaTemplate;", "publishClean", "", "storageId", "publishError", "publishInfected", "publishProcessing", "publishStatus", "message", "Lde/justsoftware/justdocumentz/virusscan/VirusScanStatusMessage;", "just-documentz"})
public class VirusScanStatusPublisher {
    @NotNull
    private final KafkaTemplate<String, Object> kafkaTemplate;

    public VirusScanStatusPublisher(@NotNull KafkaTemplate<String, Object> kafkaTemplate) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        this.kafkaTemplate = kafkaTemplate;
    }

    @NotNull
    public KafkaTemplate<String, Object> getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    public void publishStatus(@NotNull String storageId, @NotNull VirusScanStatusMessage message) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getKafkaTemplate().send(new ProducerRecord("just.virus.scan.results", (Object)storageId, (Object)message));
    }

    public void publishProcessing(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        this.publishStatus(storageId, new VirusScanStatusMessage(VirusScanStatus.PROCESSING, null));
    }

    public void publishError(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        this.publishStatus(storageId, new VirusScanStatusMessage(VirusScanStatus.ERROR, Instant.now()));
    }

    public void publishClean(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        this.publishStatus(storageId, new VirusScanStatusMessage(VirusScanStatus.CLEAN, Instant.now()));
    }

    public void publishInfected(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        this.publishStatus(storageId, new VirusScanStatusMessage(VirusScanStatus.INFECTED, Instant.now()));
    }
}

