/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.common.FileCacheService;
import de.justsoftware.justdocumentz.virusscan.VirusScanJobRunner;
import de.justsoftware.justdocumentz.virusscan.VirusScanResult;
import de.justsoftware.justdocumentz.virusscan.VirusScanService;
import de.justsoftware.justdocumentz.virusscan.VirusScanStatusPublisher;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;", "", "virusScanStatusPublisher", "Lde/justsoftware/justdocumentz/virusscan/VirusScanStatusPublisher;", "fileCacheService", "Lde/justsoftware/justdocumentz/common/FileCacheService;", "virusScanService", "Lde/justsoftware/justdocumentz/virusscan/VirusScanService;", "(Lde/justsoftware/justdocumentz/virusscan/VirusScanStatusPublisher;Lde/justsoftware/justdocumentz/common/FileCacheService;Lde/justsoftware/justdocumentz/virusscan/VirusScanService;)V", "getFileCacheService", "()Lde/justsoftware/justdocumentz/common/FileCacheService;", "getVirusScanService", "()Lde/justsoftware/justdocumentz/virusscan/VirusScanService;", "getVirusScanStatusPublisher", "()Lde/justsoftware/justdocumentz/virusscan/VirusScanStatusPublisher;", "scanForVirus", "", "storageId", "", "remoteUrl", "Companion", "just-documentz"})
public class VirusScanJobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirusScanStatusPublisher virusScanStatusPublisher;
    @NotNull
    private final FileCacheService fileCacheService;
    @NotNull
    private final VirusScanService virusScanService;
    private static final Logger logger = LoggerFactory.getLogger(VirusScanJobRunner.class);

    public VirusScanJobRunner(@NotNull VirusScanStatusPublisher virusScanStatusPublisher, @NotNull FileCacheService fileCacheService, @NotNull VirusScanService virusScanService) {
        Intrinsics.checkNotNullParameter((Object)virusScanStatusPublisher, (String)"virusScanStatusPublisher");
        Intrinsics.checkNotNullParameter((Object)fileCacheService, (String)"fileCacheService");
        Intrinsics.checkNotNullParameter((Object)virusScanService, (String)"virusScanService");
        this.virusScanStatusPublisher = virusScanStatusPublisher;
        this.fileCacheService = fileCacheService;
        this.virusScanService = virusScanService;
    }

    @NotNull
    public VirusScanStatusPublisher getVirusScanStatusPublisher() {
        return this.virusScanStatusPublisher;
    }

    @NotNull
    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }

    @NotNull
    public VirusScanService getVirusScanService() {
        return this.virusScanService;
    }

    public void scanForVirus(@NotNull String storageId, @NotNull String remoteUrl) {
        block6: {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
            Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
            logger.info("Starting virus scan for task: " + storageId);
            this.getVirusScanStatusPublisher().publishProcessing(storageId);
            Object object3 = this.getFileCacheService().downloadToFileCache-0E7RQCE(storageId, remoteUrl, true);
            if (Result.isSuccess-impl((Object)object3)) {
                Object object4;
                object2 = object3;
                try {
                    object4 = object2;
                    Path downloadedFile = (Path)object4;
                    boolean bl = false;
                    VirusScanResult virusScanResult = this.getVirusScanService().findVirus(downloadedFile);
                    boolean virusDetected = virusScanResult.component1();
                    String output = virusScanResult.component2();
                    if (virusDetected) {
                        logger.warn("Virus detected for task: " + storageId + ". output: " + output);
                        this.getVirusScanStatusPublisher().publishInfected(storageId);
                        this.getFileCacheService().removeFromFileCache(storageId);
                    } else {
                        logger.info("No virus detected for task: " + storageId);
                        this.getVirusScanStatusPublisher().publishClean(storageId);
                    }
                    object4 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable downloadedFile) {
                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)downloadedFile));
                }
                object = object4;
            } else {
                object = Result.constructor-impl((Object)object3);
            }
            object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable == null) break block6;
            Object it = object2 = throwable;
            boolean bl = false;
            logger.error("Error during virus scan for task: " + storageId, (Throwable)it);
            this.getVirusScanStatusPublisher().publishError(storageId);
        }
    }
}

