/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.connector.SuperopertyConnector;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 H\u0017J\b\u0010!\u001a\u00020\u001cH\u0017J\b\u0010\"\u001a\u00020\u001cH\u0012J\b\u0010#\u001a\u00020\u001cH\u0012J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanDaemonRunner;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "superopertyConnector", "Lde/justsoftware/justdocumentz/connector/SuperopertyConnector;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "environment", "Lorg/springframework/core/env/Environment;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/connector/SuperopertyConnector;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lorg/springframework/core/env/Environment;)V", "clamavImage", "", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "justContainerVersion", "logger", "Lorg/slf4j/Logger;", "getSuperopertyConnector", "()Lde/justsoftware/justdocumentz/connector/SuperopertyConnector;", "extractClamdConfig", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "onContextClosedEvent", "", "event", "Lorg/springframework/context/event/ContextClosedEvent;", "onRefreshEvent", "Lorg/springframework/cloud/endpoint/event/RefreshEvent;", "postConstruct", "startDaemon", "stopDaemon", "updateDaemon", "antivirusEnabled", "", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVirusScanDaemonRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirusScanDaemonRunner.kt\nde/justsoftware/justdocumentz/virusscan/VirusScanDaemonRunner\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n9#2:157\n1#3:158\n*S KotlinDebug\n*F\n+ 1 VirusScanDaemonRunner.kt\nde/justsoftware/justdocumentz/virusscan/VirusScanDaemonRunner\n*L\n32#1:157\n*E\n"})
public class VirusScanDaemonRunner {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String justContainerVersion;
    @NotNull
    private final String clamavImage;

    public VirusScanDaemonRunner(@NotNull JudoConfig config, @NotNull SuperopertyConnector superopertyConnector, @NotNull ContainerImageService containerImageService, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.config = config;
        this.superopertyConnector = superopertyConnector;
        this.containerImageService = containerImageService;
        this.environment = environment;
        VirusScanDaemonRunner $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(VirusScanDaemonRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        String string = this.getEnvironment().getProperty("just.containerVersion", "latest");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.justContainerVersion = string;
        this.clamavImage = "docker.io/justsocial/just-clamav:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public SuperopertyConnector getSuperopertyConnector() {
        return this.superopertyConnector;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @PostConstruct
    public void postConstruct() {
        String[] stringArray = this.getEnvironment().getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        if (ArraysKt.contains((Object[])stringArray, (Object)"jenkins")) {
            this.logger.info("Skipping " + this.getClass().getSimpleName() + " initialization in Jenkins");
            return;
        }
        this.logger.info("Initializing " + this.getClass().getSimpleName() + "...");
        if (!this.getContainerImageService().isPodmanAvailable()) {
            boolean bl = false;
            String string = "Podman is not available on this system. Please install Podman to use virus scan.";
            throw new IllegalStateException(string.toString());
        }
        this.getContainerImageService().ensureImageAvailable(this.clamavImage);
        this.updateDaemon(this.getSuperopertyConnector().getAntivirusEnabled());
    }

    @EventListener
    public void onRefreshEvent(@NotNull RefreshEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getEvent();
        TreeCacheEvent treeCacheEvent = object instanceof TreeCacheEvent ? (TreeCacheEvent)object : null;
        if (Intrinsics.areEqual((Object)(treeCacheEvent != null && (treeCacheEvent = treeCacheEvent.getData()) != null ? treeCacheEvent.getPath() : null), (Object)"/just/config/just/common/antivirusEnabled")) {
            this.logger.info("Update Virus Scan Daemon due to RefreshEvent: " + event);
            this.updateDaemon(this.getSuperopertyConnector().getAntivirusEnabled());
        }
    }

    @EventListener
    public void onContextClosedEvent(@NotNull ContextClosedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.logger.info("Stop Virus Scan Daemon due to ContextClosedEvent: " + event);
        this.updateDaemon(false);
    }

    private void updateDaemon(boolean antivirusEnabled) {
        boolean running = this.getContainerImageService().isContainerRunning("judo-clamd");
        if (antivirusEnabled) {
            if (running) {
                this.logger.info("Virus Scan Daemon already running");
            } else {
                Object it;
                Object $this$updateDaemon_u24lambda_u241;
                VirusScanDaemonRunner virusScanDaemonRunner = this;
                try {
                    $this$updateDaemon_u24lambda_u241 = virusScanDaemonRunner;
                    boolean bl = false;
                    $this$updateDaemon_u24lambda_u241.startDaemon();
                    $this$updateDaemon_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$updateDaemon_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                virusScanDaemonRunner = $this$updateDaemon_u24lambda_u241;
                if (Result.isSuccess-impl((Object)virusScanDaemonRunner)) {
                    it = (Unit)virusScanDaemonRunner;
                    boolean bl = false;
                    this.logger.info("Virus Scan Daemon has been started");
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)virusScanDaemonRunner);
                if (throwable != null) {
                    Object it2 = it = throwable;
                    boolean bl = false;
                    this.logger.error("Error while starting Virus Scan Daemon", (Throwable)it2);
                }
            }
        } else if (running) {
            Object $this$updateDaemon_u24lambda_u244;
            VirusScanDaemonRunner virusScanDaemonRunner = this;
            try {
                $this$updateDaemon_u24lambda_u244 = virusScanDaemonRunner;
                boolean bl = false;
                $this$updateDaemon_u24lambda_u244.stopDaemon();
                $this$updateDaemon_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$updateDaemon_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            virusScanDaemonRunner = $this$updateDaemon_u24lambda_u244;
            if (Result.isSuccess-impl((Object)virusScanDaemonRunner)) {
                Unit it = (Unit)virusScanDaemonRunner;
                boolean bl = false;
                this.logger.info("Virus Scan Daemon has been stopped");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)virusScanDaemonRunner);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                this.logger.error("Error while stopping Virus Scan Daemon", it);
            }
        } else {
            this.logger.info("Virus Scan Daemon already stopped");
        }
    }

    private void startDaemon() {
        FileUtilsKt.ensureDirectoryExists((Path)this.getConfig().getCacheDirPath());
        FileUtilsKt.ensureDirectoryExists((Path)this.getConfig().getVirusScan().getLogDirPath());
        Pair pair = this.extractClamdConfig();
        Path clamdConfPath = (Path)pair.component1();
        Path freshclamConfPath = (Path)pair.component2();
        this.logger.info("Start Virus Scan Daemon container");
        Object[] objectArray = new String[]{"--name", "judo-clamd", "-d", "-v", this.getConfig().getCacheDirPath() + ":/scandir:ro", "-v", clamdConfPath + ":/etc/clamav/clamd.conf:ro", "-v", freshclamConfPath + ":/etc/clamav/freshclam.conf:ro", "-v", this.getConfig().getVirusScan().getLogDirPath() + ":/var/log/clamav", this.clamavImage};
        CommandLineUtilsKt.podmanRun-5_5nbZA$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getVirusScanDaemon(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), null, (int)8, null);
        this.logger.info("Container started. Wait until Virus Scan Daemon is ready");
        boolean started = this.getContainerImageService().waitForContainerLog-SxA4cEA("judo-clamd", "socket found, clamd started.", DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        if (!started) {
            this.stopDaemon();
            throw new IllegalStateException("Virus Scan Daemon did not start within configured timeout so we explicitly stopped it".toString());
        }
    }

    private void stopDaemon() {
        this.getContainerImageService().stopContainer("judo-clamd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Path, Path> extractClamdConfig() {
        Unit unit;
        Unit unit2;
        CopyOption[] copyOptionArray;
        InputStream input2;
        Throwable throwable;
        Closeable closeable;
        Path tempConfDir = Files.createTempDirectory("clamav-config", new FileAttribute[0]);
        Path clamdConf = tempConfDir.resolve("clamd.conf");
        Path freshClamConf = tempConfDir.resolve("freshclam.conf");
        InputStream inputStream = this.getClass().getResourceAsStream("/assets/clamd.conf");
        if (inputStream != null) {
            closeable = inputStream;
            throwable = null;
            try {
                input2 = (InputStream)closeable;
                boolean bl = false;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(input2, clamdConf, copyOptionArray);
                this.logger.info("Copied `clamd.conf` to " + clamdConf);
                input2 = Unit.INSTANCE;
            }
            catch (Throwable input2) {
                throwable = input2;
                throw input2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        if (unit2 == null) {
            throw new IllegalStateException("clamd.conf not found in resources".toString());
        }
        InputStream inputStream2 = this.getClass().getResourceAsStream("/assets/freshclam.conf");
        if (inputStream2 != null) {
            closeable = inputStream2;
            throwable = null;
            try {
                input2 = (InputStream)closeable;
                boolean bl = false;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(input2, freshClamConf, copyOptionArray);
                this.logger.info("Copied `freshclam.conf` to " + freshClamConf);
                Unit unit3 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("freshclam.conf not found in resources".toString());
        }
        return new Pair((Object)clamdConf, (Object)freshClamConf);
    }
}

