/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.virusscan.KafkaVirusScanTaskListener;
import de.justsoftware.justdocumentz.virusscan.VirusScanJobRunner;
import de.justsoftware.justdocumentz.virusscan.VirusScanTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/justdocumentz/virusscan/KafkaVirusScanTaskListener;", "", "virusScanJobRunner", "Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;", "(Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;)V", "getVirusScanJobRunner", "()Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;", "listen", "", "key", "", "task", "Lde/justsoftware/justdocumentz/virusscan/VirusScanTask;", "Companion", "just-documentz"})
public class KafkaVirusScanTaskListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirusScanJobRunner virusScanJobRunner;
    private static final Logger logger = LoggerFactory.getLogger(KafkaVirusScanTaskListener.class);

    public KafkaVirusScanTaskListener(@NotNull VirusScanJobRunner virusScanJobRunner) {
        Intrinsics.checkNotNullParameter((Object)virusScanJobRunner, (String)"virusScanJobRunner");
        this.virusScanJobRunner = virusScanJobRunner;
    }

    @NotNull
    public VirusScanJobRunner getVirusScanJobRunner() {
        return this.virusScanJobRunner;
    }

    @KafkaListener(containerFactory="kafkaVirusScanTaskListenerContainerFactory", topics={"just.virus.scan"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload @NotNull VirusScanTask task) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        logger.info("Received virus scan task for task: " + key);
        VirusScanJobRunner virusScanJobRunner = this.getVirusScanJobRunner();
        String string = task.getStorageId();
        if (string == null) {
            string = key;
        }
        virusScanJobRunner.scanForVirus(string, task.getRemoteUrl());
    }
}

