/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.util;

import de.justsoftware.justdocumentz.util.DeleteDirFileVisitor;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"deleteDirectory", "", "path", "Ljava/nio/file/Path;", "ensureDirectoryExists", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\nde/justsoftware/justdocumentz/util/FileUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class FileUtilsKt {
    public static final void ensureDirectoryExists(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            boolean bl = false;
            String string = "A file by name " + path + " already exists, can't create folder!";
            throw new IllegalArgumentException(string.toString());
        }
        Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxrwxrwx"));
    }

    public static final void deleteDirectory(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            boolean bl = false;
            String string = path + " is not a directory";
            throw new IllegalArgumentException(string.toString());
        }
        Files.walkFileTree(path, (FileVisitor)new DeleteDirFileVisitor());
    }
}

