/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.document;

import de.justsoftware.justdocumentz.util.CommandLineResult;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;", "", "()V", "detectType", "", "inputFile", "Ljava/nio/file/Path;", "isMsOfficeArchive", "", "just-documentz"})
public class FileTypeDetectionService {
    @NotNull
    public String detectType(@NotNull Path inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Object[] objectArray = new String[]{"sh", "-c", "LC_ALL=C file " + inputFile + " | cut -d ':' -f 2- | cut -d ',' -f 1 | sed -e 's| ||' | sed -e 's| \\+| |g'"};
        String output = CommandLineUtilsKt.executeCommandLine-Kx4hsE0$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)), null, (int)4, null).component1();
        return ((Object)StringsKt.trim((CharSequence)output)).toString();
    }

    public boolean isMsOfficeArchive(@NotNull Path inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Object[] objectArray = new String[]{"sh", "-c", "unzip -v " + inputFile + " | grep -c 'docProps/app.xml'"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{0, 1};
        CommandLineResult commandLineResult = CommandLineUtilsKt.executeCommandLine-Kx4hsE0((List)list, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)), (Collection)SetsKt.setOf((Object[])objectArray));
        String output = commandLineResult.component1();
        int exitCode = commandLineResult.component2();
        return exitCode == 0 && Integer.parseInt(((Object)StringsKt.trim((CharSequence)output)).toString()) > 0;
    }
}

