/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions;

import de.justsoftware.justdocumentz.conversions.ConversionJobService;
import de.justsoftware.justdocumentz.conversions.ConversionTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/justdocumentz/conversions/KafkaConversionTaskListener;", "", "conversionJobService", "Lde/justsoftware/justdocumentz/conversions/ConversionJobService;", "(Lde/justsoftware/justdocumentz/conversions/ConversionJobService;)V", "getConversionJobService", "()Lde/justsoftware/justdocumentz/conversions/ConversionJobService;", "logger", "Lorg/slf4j/Logger;", "listen", "", "task", "Lde/justsoftware/justdocumentz/conversions/ConversionTask;", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionKafka.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionKafka.kt\nde/justsoftware/justdocumentz/conversions/KafkaConversionTaskListener\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,107:1\n9#2:108\n*S KotlinDebug\n*F\n+ 1 DocumentConversionKafka.kt\nde/justsoftware/justdocumentz/conversions/KafkaConversionTaskListener\n*L\n38#1:108\n*E\n"})
public class KafkaConversionTaskListener {
    @NotNull
    private final ConversionJobService conversionJobService;
    @NotNull
    private final Logger logger;

    public KafkaConversionTaskListener(@NotNull ConversionJobService conversionJobService) {
        Intrinsics.checkNotNullParameter((Object)conversionJobService, (String)"conversionJobService");
        this.conversionJobService = conversionJobService;
        KafkaConversionTaskListener $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(KafkaConversionTaskListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public ConversionJobService getConversionJobService() {
        return this.conversionJobService;
    }

    @KafkaListener(containerFactory="kafkaConversionTaskListenerContainerFactory", topics={"just.documents.conversion.taskv2"})
    public void listen(@Payload @NotNull ConversionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.logger.info("Received conversion task for task: " + task.getId());
        this.getConversionJobService().convertDocument(task);
    }
}

