/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.controller;

import de.justsoftware.justdocumentz.controller.DocumentApiService;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0012\b\u0001\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0017J\b\u0010\r\u001a\u00020\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/justdocumentz/controller/DocumentApiController;", "", "documentApiService", "Lde/justsoftware/justdocumentz/controller/DocumentApiService;", "(Lde/justsoftware/justdocumentz/controller/DocumentApiService;)V", "getDocumentApiService", "()Lde/justsoftware/justdocumentz/controller/DocumentApiService;", "deleteAll", "", "documentIds", "", "Ljava/util/UUID;", "Lde/justsoftware/justdocumentz/model/DocumentId;", "deletePreviewSources", "just-documentz"})
public class DocumentApiController {
    @NotNull
    private final DocumentApiService documentApiService;

    public DocumentApiController(@NotNull DocumentApiService documentApiService) {
        Intrinsics.checkNotNullParameter((Object)documentApiService, (String)"documentApiService");
        this.documentApiService = documentApiService;
    }

    @NotNull
    public DocumentApiService getDocumentApiService() {
        return this.documentApiService;
    }

    @ResponseBody
    @DeleteMapping(value={"/api/v1/documents/deletePreviewSources"})
    public void deletePreviewSources() {
        this.getDocumentApiService().deletePreviewSources();
    }

    @DeleteMapping(value={"/api/v1/documents"})
    @ResponseBody
    public void deleteAll(@RequestBody @NotNull List<UUID> documentIds) {
        Intrinsics.checkNotNullParameter(documentIds, (String)"documentIds");
        this.getDocumentApiService().deleteAll(documentIds);
    }
}

