/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.config;

import de.justsoftware.justdocumentz.config.ContainersConfig;
import de.justsoftware.justdocumentz.config.ConverterConfig;
import de.justsoftware.justdocumentz.config.ScheduledConfig;
import de.justsoftware.justdocumentz.config.VirusScanConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="judo")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003J\t\u0010-\u001a\u00020\fH\u00c6\u0003J\t\u0010.\u001a\u00020\u000eH\u00c6\u0003JY\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\u000e\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0003J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011R\u0011\u0010#\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Lde/justsoftware/justdocumentz/config/JudoConfig;", "", "storageDir", "", "tempDir", "cacheDir", "convertedVideoDir", "converter", "Lde/justsoftware/justdocumentz/config/ConverterConfig;", "virusScan", "Lde/justsoftware/justdocumentz/config/VirusScanConfig;", "podman", "Lde/justsoftware/justdocumentz/config/ContainersConfig;", "scheduled", "Lde/justsoftware/justdocumentz/config/ScheduledConfig;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/justdocumentz/config/ConverterConfig;Lde/justsoftware/justdocumentz/config/VirusScanConfig;Lde/justsoftware/justdocumentz/config/ContainersConfig;Lde/justsoftware/justdocumentz/config/ScheduledConfig;)V", "getCacheDir", "()Ljava/lang/String;", "cacheDirPath", "Ljava/nio/file/Path;", "getCacheDirPath", "()Ljava/nio/file/Path;", "getConvertedVideoDir", "convertedVideoDirPath", "getConvertedVideoDirPath", "getConverter", "()Lde/justsoftware/justdocumentz/config/ConverterConfig;", "getPodman", "()Lde/justsoftware/justdocumentz/config/ContainersConfig;", "getScheduled", "()Lde/justsoftware/justdocumentz/config/ScheduledConfig;", "getStorageDir", "storageDirPath", "getStorageDirPath", "getTempDir", "tempDirPath", "getTempDirPath", "getVirusScan", "()Lde/justsoftware/justdocumentz/config/VirusScanConfig;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "outputDir", "jobId", "toString", "just-documentz"})
public final class JudoConfig {
    @NotNull
    private final String storageDir;
    @NotNull
    private final String tempDir;
    @NotNull
    private final String cacheDir;
    @NotNull
    private final String convertedVideoDir;
    @NotNull
    private final ConverterConfig converter;
    @NotNull
    private final VirusScanConfig virusScan;
    @NotNull
    private final ContainersConfig podman;
    @NotNull
    private final ScheduledConfig scheduled;

    public JudoConfig(@NotNull String storageDir, @NotNull String tempDir, @NotNull String cacheDir, @NotNull String convertedVideoDir, @NotNull ConverterConfig converter, @NotNull VirusScanConfig virusScan, @NotNull ContainersConfig podman, @NotNull ScheduledConfig scheduled) {
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)convertedVideoDir, (String)"convertedVideoDir");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        Intrinsics.checkNotNullParameter((Object)virusScan, (String)"virusScan");
        Intrinsics.checkNotNullParameter((Object)podman, (String)"podman");
        Intrinsics.checkNotNullParameter((Object)scheduled, (String)"scheduled");
        this.storageDir = storageDir;
        this.tempDir = tempDir;
        this.cacheDir = cacheDir;
        this.convertedVideoDir = convertedVideoDir;
        this.converter = converter;
        this.virusScan = virusScan;
        this.podman = podman;
        this.scheduled = scheduled;
    }

    public /* synthetic */ JudoConfig(String string, String string2, String string3, String string4, ConverterConfig converterConfig, VirusScanConfig virusScanConfig, ContainersConfig containersConfig, ScheduledConfig scheduledConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            converterConfig = new ConverterConfig(0, 0, 3, null);
        }
        if ((n & 0x20) != 0) {
            virusScanConfig = new VirusScanConfig(0, null, 3, null);
        }
        if ((n & 0x40) != 0) {
            containersConfig = new ContainersConfig(null, null, null, 7, null);
        }
        if ((n & 0x80) != 0) {
            scheduledConfig = new ScheduledConfig(null, 1, null);
        }
        this(string, string2, string3, string4, converterConfig, virusScanConfig, containersConfig, scheduledConfig);
    }

    @NotNull
    public final String getStorageDir() {
        return this.storageDir;
    }

    @NotNull
    public final String getTempDir() {
        return this.tempDir;
    }

    @NotNull
    public final String getCacheDir() {
        return this.cacheDir;
    }

    @NotNull
    public final String getConvertedVideoDir() {
        return this.convertedVideoDir;
    }

    @NotNull
    public final ConverterConfig getConverter() {
        return this.converter;
    }

    @NotNull
    public final VirusScanConfig getVirusScan() {
        return this.virusScan;
    }

    @NotNull
    public final ContainersConfig getPodman() {
        return this.podman;
    }

    @NotNull
    public final ScheduledConfig getScheduled() {
        return this.scheduled;
    }

    @NotNull
    public final Path getStorageDirPath() {
        Path path = Paths.get(this.storageDir, new String[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    @NotNull
    public final Path getTempDirPath() {
        Path path = Paths.get(this.tempDir, new String[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    @NotNull
    public final Path getCacheDirPath() {
        Path path = Paths.get(this.cacheDir, new String[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    @NotNull
    public final Path getConvertedVideoDirPath() {
        Path path = Paths.get(this.convertedVideoDir, new String[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    @NotNull
    public final Path outputDir(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Path path = this.getStorageDirPath().resolve(jobId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final String component1() {
        return this.storageDir;
    }

    @NotNull
    public final String component2() {
        return this.tempDir;
    }

    @NotNull
    public final String component3() {
        return this.cacheDir;
    }

    @NotNull
    public final String component4() {
        return this.convertedVideoDir;
    }

    @NotNull
    public final ConverterConfig component5() {
        return this.converter;
    }

    @NotNull
    public final VirusScanConfig component6() {
        return this.virusScan;
    }

    @NotNull
    public final ContainersConfig component7() {
        return this.podman;
    }

    @NotNull
    public final ScheduledConfig component8() {
        return this.scheduled;
    }

    @NotNull
    public final JudoConfig copy(@NotNull String storageDir, @NotNull String tempDir, @NotNull String cacheDir, @NotNull String convertedVideoDir, @NotNull ConverterConfig converter, @NotNull VirusScanConfig virusScan, @NotNull ContainersConfig podman, @NotNull ScheduledConfig scheduled) {
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)convertedVideoDir, (String)"convertedVideoDir");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        Intrinsics.checkNotNullParameter((Object)virusScan, (String)"virusScan");
        Intrinsics.checkNotNullParameter((Object)podman, (String)"podman");
        Intrinsics.checkNotNullParameter((Object)scheduled, (String)"scheduled");
        return new JudoConfig(storageDir, tempDir, cacheDir, convertedVideoDir, converter, virusScan, podman, scheduled);
    }

    public static /* synthetic */ JudoConfig copy$default(JudoConfig judoConfig, String string, String string2, String string3, String string4, ConverterConfig converterConfig, VirusScanConfig virusScanConfig, ContainersConfig containersConfig, ScheduledConfig scheduledConfig, int n, Object object) {
        if ((n & 1) != 0) {
            string = judoConfig.storageDir;
        }
        if ((n & 2) != 0) {
            string2 = judoConfig.tempDir;
        }
        if ((n & 4) != 0) {
            string3 = judoConfig.cacheDir;
        }
        if ((n & 8) != 0) {
            string4 = judoConfig.convertedVideoDir;
        }
        if ((n & 0x10) != 0) {
            converterConfig = judoConfig.converter;
        }
        if ((n & 0x20) != 0) {
            virusScanConfig = judoConfig.virusScan;
        }
        if ((n & 0x40) != 0) {
            containersConfig = judoConfig.podman;
        }
        if ((n & 0x80) != 0) {
            scheduledConfig = judoConfig.scheduled;
        }
        return judoConfig.copy(string, string2, string3, string4, converterConfig, virusScanConfig, containersConfig, scheduledConfig);
    }

    @NotNull
    public String toString() {
        return "JudoConfig(storageDir=" + this.storageDir + ", tempDir=" + this.tempDir + ", cacheDir=" + this.cacheDir + ", convertedVideoDir=" + this.convertedVideoDir + ", converter=" + this.converter + ", virusScan=" + this.virusScan + ", podman=" + this.podman + ", scheduled=" + this.scheduled + ")";
    }

    public int hashCode() {
        int result = this.storageDir.hashCode();
        result = result * 31 + this.tempDir.hashCode();
        result = result * 31 + this.cacheDir.hashCode();
        result = result * 31 + this.convertedVideoDir.hashCode();
        result = result * 31 + this.converter.hashCode();
        result = result * 31 + this.virusScan.hashCode();
        result = result * 31 + this.podman.hashCode();
        result = result * 31 + this.scheduled.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JudoConfig)) {
            return false;
        }
        JudoConfig judoConfig = (JudoConfig)other;
        if (!Intrinsics.areEqual((Object)this.storageDir, (Object)judoConfig.storageDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tempDir, (Object)judoConfig.tempDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cacheDir, (Object)judoConfig.cacheDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.convertedVideoDir, (Object)judoConfig.convertedVideoDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.converter, (Object)judoConfig.converter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.virusScan, (Object)judoConfig.virusScan)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.podman, (Object)judoConfig.podman)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scheduled, (Object)judoConfig.scheduled);
    }
}

