/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.common;

import de.justsoftware.justdocumentz.util.CommandLineResult;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0012\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\bH\u0016J*\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/justdocumentz/common/ContainerImageService;", "", "()V", "logger", "Lorg/slf4j/Logger;", "ensureImageAvailable", "", "imageName", "", "imageExists", "isContainerRunning", "containerName", "isPodmanAvailable", "performImagePull", "pullImageWithProgress", "readUntil", "reader", "Ljava/io/BufferedReader;", "targetText", "timeout", "Lkotlin/time/Duration;", "readUntil-SxA4cEA", "(Ljava/io/BufferedReader;Ljava/lang/String;J)Z", "stopContainer", "Lde/justsoftware/justdocumentz/util/CommandLineResult;", "waitForContainerLog", "waitForContainerLog-SxA4cEA", "(Ljava/lang/String;Ljava/lang/String;J)Z", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nContainerImageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerImageService.kt\nde/justsoftware/justdocumentz/common/ContainerImageService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n9#2:164\n1#3:165\n*S KotlinDebug\n*F\n+ 1 ContainerImageService.kt\nde/justsoftware/justdocumentz/common/ContainerImageService\n*L\n20#1:164\n*E\n"})
public class ContainerImageService {
    @NotNull
    private final Logger logger;

    public ContainerImageService() {
        ContainerImageService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(ContainerImageService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public boolean isPodmanAvailable() {
        Object object;
        Object object2 = this;
        try {
            ContainerImageService $this$isPodmanAvailable_u24lambda_u240 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"podman", "--version"};
            Process process = new ProcessBuilder(stringArray).start();
            object = Result.constructor-impl((Object)(process.waitFor(10L, TimeUnit.SECONDS) && process.exitValue() == 0 ? 1 : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public boolean pullImageWithProgress(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        this.logger.info(StringsKt.repeat((CharSequence)"=", (int)80));
        this.logger.info("\ud83d\udc33 INITIALIZING CONTAINER IMAGE");
        this.logger.info("Image: " + imageName);
        this.logger.info("This may take a few minutes on first startup...");
        this.logger.info(StringsKt.repeat((CharSequence)"=", (int)80));
        boolean success = this.performImagePull(imageName);
        if (success) {
            this.logger.info("\u2705 Container image ready!");
        } else {
            this.logger.error("\u274c Failed to pull container image: " + imageName);
        }
        return success;
    }

    public boolean imageExists(@NotNull String imageName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Object object2 = this;
        try {
            ContainerImageService $this$imageExists_u24lambda_u241 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"podman", "image", "exists", imageName};
            Process process = new ProcessBuilder(stringArray).start();
            int exitCode = process.waitFor();
            object = Result.constructor-impl((Object)(exitCode == 0 ? 1 : 0));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            this.logger.debug("Error checking if image exists: " + ((Throwable)e).getMessage());
        }
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public boolean ensureImageAvailable(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        if (this.imageExists(imageName)) {
            this.logger.info("\u2705 Container image already available: " + imageName);
            return true;
        }
        this.logger.info("\ud83d\udce5 Container image not found locally, pulling: " + imageName);
        return this.pullImageWithProgress(imageName);
    }

    private boolean performImagePull(String imageName) {
        Object object;
        Object object2 = this;
        try {
            ContainerImageService $this$performImagePull_u24lambda_u245 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"podman", "pull", imageName};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while (true) {
                String currentLine;
                String string;
                String it = string = reader.readLine();
                boolean bl2 = false;
                line = it;
                if (string == null) break;
                if (line == null) continue;
                $this$performImagePull_u24lambda_u245.logger.info(currentLine);
            }
            int exitCode = process.waitFor();
            reader.close();
            if (!(exitCode == 0)) {
                boolean bl3 = false;
                String string = "\u274c Image pull failed with exit code: " + exitCode;
                throw new IllegalStateException(string.toString());
            }
            $this$performImagePull_u24lambda_u245.logger.info("\ud83c\udf89 Image pull completed successfully!");
            object = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            this.logger.error("\u274c Exception during image pull: " + ((Throwable)e).getMessage(), (Throwable)e);
        }
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public boolean isContainerRunning(@NotNull String containerName) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "ps", "--filter", "name=" + containerName, "--format", "{{.Names}}"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        CommandLineResult result = CommandLineUtilsKt.executeCommandLine-Kx4hsE0$default((List)command, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)), null, (int)4, null);
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)result.getOutput())).toString(), (Object)containerName);
    }

    @NotNull
    public CommandLineResult stopContainer(@NotNull String containerName) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "stop", "--time", "30", containerName};
        return CommandLineUtilsKt.executeCommandLine-Kx4hsE0$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)40, (DurationUnit)DurationUnit.SECONDS)), null, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForContainerLog-SxA4cEA(@NotNull String containerName, @NotNull String targetText, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        Object[] objectArray = new String[]{"podman", "logs", "-f", containerName};
        List command = CollectionsKt.listOf((Object[])objectArray);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean bl = this.readUntil-SxA4cEA(reader, targetText, timeout);
            return bl;
        }
        finally {
            if (process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    private boolean readUntil-SxA4cEA(BufferedReader reader, String targetText, long timeout) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < Duration.getInWholeMilliseconds-impl((long)timeout)) {
            if (reader.ready()) {
                String line = reader.readLine();
                if (line == null || !StringsKt.contains$default((CharSequence)line, (CharSequence)targetText, (boolean)false, (int)2, null)) continue;
                return true;
            }
            Thread.sleep(500L);
        }
        return false;
    }
}

