/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.services.runner;

import de.justsoftware.jdoc.services.tasks.processes.ProcessWatchdogService;
import de.justsoftware.judo.services.FileCacheService;
import de.justsoftware.judo.services.runner.ScriptRunnerService;
import de.justsoftware.judoclient.model.ConversionTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class VideoScriptRunnerService
extends ScriptRunnerService {
    private static final int MAX_EXECUTION_TIME = 1800000;
    private final File _converterScript;
    private final FileCacheService _fileCacheService;

    @Autowired
    public VideoScriptRunnerService(@Value(value="${services.converter.video}") String scriptPath, ProcessWatchdogService watchdogService, FileCacheService fileCacheService, MeterRegistry meterRegistry, @Value(value="${judo.monitoring.video.queueSize: 4}") int monitoringQueueSize, @Value(value="${judo.monitoring.video.errorThreshold: 3}") int monitoringErrorThreshold) {
        super(scriptPath, watchdogService, 1800000, meterRegistry, monitoringQueueSize, monitoringErrorThreshold);
        this._fileCacheService = fileCacheService;
        this._converterScript = new File(scriptPath);
    }

    @Nonnull
    String[] getScriptArguments(File source, ConversionTask conversion) throws IOException {
        return new String[]{"-i", source.getAbsolutePath(), "-o", this._fileCacheService.getConvertedFileLocation(conversion.getId()).getAbsolutePath() + ".converted.mp4", "-c", this._fileCacheService.getConvertedFileLocation(conversion.getId()).getAbsolutePath() + ".converted_cover.png"};
    }

    File getScriptFile() {
        return this._converterScript;
    }

    Executor getScriptExecutor() {
        DefaultExecutor exec = new DefaultExecutor();
        exec.setExitValue(0);
        return exec;
    }
}

