/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller.internal;

import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.controller.internal.PublicApiClient;
import de.justsoftware.authorization.controller.internal.PublicApiClientCreateRequest;
import de.justsoftware.authorization.controller.internal.PublicApiClientCreateResponse;
import de.justsoftware.authorization.controller.internal.PublicApiClientUpdateRequest;
import de.justsoftware.authorization.oauth2.client.PublicApiService;
import java.util.List;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/publicApi"}, produces={"application/json"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0017\u001a\u00020\t2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/authorization/controller/internal/InternalPublicApiClientController;", "", "publicApiService", "Lde/justsoftware/authorization/oauth2/client/PublicApiService;", "<init>", "(Lde/justsoftware/authorization/oauth2/client/PublicApiService;)V", "getPublicApiService", "()Lde/justsoftware/authorization/oauth2/client/PublicApiService;", "generateClient", "Lde/justsoftware/authorization/controller/internal/PublicApiClientCreateResponse;", "publicApiRequest", "Lde/justsoftware/authorization/controller/internal/PublicApiClientCreateRequest;", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "updateClient", "Lde/justsoftware/authorization/controller/internal/PublicApiClient;", "clientId", "", "Lde/justsoftware/authorization/controller/internal/PublicApiClientUpdateRequest;", "getAllClients", "", "deleteClient", "", "generateNewSecret", "just-authorization-server"})
public class InternalPublicApiClientController {
    @NotNull
    private final PublicApiService publicApiService;

    public InternalPublicApiClientController(@NotNull PublicApiService publicApiService) {
        Intrinsics.checkNotNullParameter((Object)publicApiService, (String)"publicApiService");
        this.publicApiService = publicApiService;
    }

    @NotNull
    public PublicApiService getPublicApiService() {
        return this.publicApiService;
    }

    @Nonnull
    @PostMapping(value={"/client"})
    @NotNull
    public PublicApiClientCreateResponse generateClient(@RequestBody @NotNull PublicApiClientCreateRequest publicApiRequest, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)publicApiRequest, (String)"publicApiRequest");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.getPublicApiService().createClient(publicApiRequest, authContext);
    }

    @Nonnull
    @PostMapping(value={"/client/{clientId}"})
    @NotNull
    public PublicApiClient updateClient(@PathVariable @NotNull String clientId, @RequestBody @NotNull PublicApiClientUpdateRequest publicApiRequest, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)publicApiRequest, (String)"publicApiRequest");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.getPublicApiService().updateClient(clientId, publicApiRequest, authContext);
    }

    @GetMapping(value={"/clients"})
    @NotNull
    public List<PublicApiClient> getAllClients(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.getPublicApiService().getAllClients(authContext);
    }

    @DeleteMapping(value={"/client"})
    public void deleteClient(@RequestParam @NotNull String clientId, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.getPublicApiService().deleteClient(clientId, authContext);
    }

    @PutMapping(value={"/client/{clientId}/generateNewSecret"})
    @NotNull
    public PublicApiClientCreateResponse generateNewSecret(@PathVariable @NotNull String clientId, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.getPublicApiService().generateNewClientSecret(clientId, authContext);
    }
}

