/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.stats;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.stats.UserStatsRepository;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0011\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/authorization/stats/UserStatsRepository;", "", "<init>", "()V", "updateLastLoginMobile", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "timestamp", "Ljava/time/Instant;", "updateLastLoginDesktop", "updateLastAccessMobile", "updateLastAccessDesktop", "deleteStatsFromDeletedProfiles", "findStatsByProfileId", "Lorg/jetbrains/exposed/sql/ResultRow;", "findStatsByProfileId$just_authorization_server", "UserStat", "just-authorization-server"})
public class UserStatsRepository {
    public void updateLastLoginMobile(@NotNull ProfileId profileId, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        QueriesKt.upsert$default((Table)((Table)UserStat.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> UserStatsRepository.updateLastLoginMobile$lambda$0(profileId, timestamp, arg_0, arg_1), (int)14, null);
    }

    public void updateLastLoginDesktop(@NotNull ProfileId profileId, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        QueriesKt.upsert$default((Table)((Table)UserStat.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> UserStatsRepository.updateLastLoginDesktop$lambda$1(profileId, timestamp, arg_0, arg_1), (int)14, null);
    }

    public void updateLastAccessMobile(@NotNull ProfileId profileId, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        QueriesKt.upsert$default((Table)((Table)UserStat.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> UserStatsRepository.updateLastAccessMobile$lambda$2(profileId, timestamp, arg_0, arg_1), (int)14, null);
    }

    public void updateLastAccessDesktop(@NotNull ProfileId profileId, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        QueriesKt.upsert$default((Table)((Table)UserStat.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> UserStatsRepository.updateLastAccessDesktop$lambda$3(profileId, timestamp, arg_0, arg_1), (int)14, null);
    }

    public void deleteStatsFromDeletedProfiles() {
        ThreadLocalTransactionManagerKt.transaction$default(null, UserStatsRepository::deleteStatsFromDeletedProfiles$lambda$4, (int)1, null);
    }

    @VisibleForTesting
    @Nullable
    public ResultRow findStatsByProfileId$just_authorization_server(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return (ResultRow)CollectionsKt.singleOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)UserStat.INSTANCE)).where(arg_0 -> UserStatsRepository.findStatsByProfileId$lambda$5(profileId, arg_0))));
    }

    private static final Unit updateLastLoginMobile$lambda$0(ProfileId $profileId, Instant $timestamp, UserStat $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setWithEntityIdValue($this$upsert.getId(), (Object)$profileId.toTypedString());
        it.set($this$upsert.getLastLoginMobile(), (Object)$timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit updateLastLoginDesktop$lambda$1(ProfileId $profileId, Instant $timestamp, UserStat $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setWithEntityIdValue($this$upsert.getId(), (Object)$profileId.toTypedString());
        it.set($this$upsert.getLastLoginDesktop(), (Object)$timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit updateLastAccessMobile$lambda$2(ProfileId $profileId, Instant $timestamp, UserStat $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setWithEntityIdValue($this$upsert.getId(), (Object)$profileId.toTypedString());
        it.set($this$upsert.getLastAccessMobile(), (Object)$timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit updateLastAccessDesktop$lambda$3(ProfileId $profileId, Instant $timestamp, UserStat $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setWithEntityIdValue($this$upsert.getId(), (Object)$profileId.toTypedString());
        it.set($this$upsert.getLastAccessDesktop(), (Object)$timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit deleteStatsFromDeletedProfiles$lambda$4(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return Transaction.exec$default((Transaction)$this$transaction, (String)"\n                    DELETE FROM justauth.user_stat WHERE profile_id IN (\n                        SELECT us.profile_id from justauth.user_stat us\n                        LEFT JOIN public.person p ON us.profile_id = CONCAT('PROFILE,', p.id) where p.id is NULL OR p.deleted = 't'\n                    )\n            ", null, null, (int)6, null);
    }

    private static final Op findStatsByProfileId$lambda$5(ProfileId $profileId, SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return $this$where.eqEntityIDValue((ExpressionWithColumnType)UserStat.INSTANCE.getId(), (Object)$profileId.toTypedString());
    }
}

