/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.connector.PermissionConnector;
import de.justsoftware.authorization.controller.internal.PublicApiClient;
import de.justsoftware.authorization.controller.internal.PublicApiClientCreateRequest;
import de.justsoftware.authorization.controller.internal.PublicApiClientCreateResponse;
import de.justsoftware.authorization.controller.internal.PublicApiClientUpdateRequest;
import de.justsoftware.authorization.id.ItemId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepository;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.GrantType;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import de.justsoftware.authorization.token.Scope;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0012J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0012J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aH\u0012J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/authorization/oauth2/client/PublicApiService;", "", "clientRepository", "Lde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "permissionConnector", "Lde/justsoftware/authorization/connector/PermissionConnector;", "<init>", "(Lde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository;Lorg/springframework/security/crypto/password/PasswordEncoder;Lde/justsoftware/authorization/connector/PermissionConnector;)V", "createClient", "Lde/justsoftware/authorization/controller/internal/PublicApiClientCreateResponse;", "createRequest", "Lde/justsoftware/authorization/controller/internal/PublicApiClientCreateRequest;", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "getAllClients", "", "Lde/justsoftware/authorization/controller/internal/PublicApiClient;", "updateClient", "clientId", "", "updateRequest", "Lde/justsoftware/authorization/controller/internal/PublicApiClientUpdateRequest;", "getScopesFromEnum", "scopes", "", "Lde/justsoftware/authorization/token/Scope;", "getAuthorizationGrantTypesFromEnum", "Lorg/springframework/security/oauth2/core/AuthorizationGrantType;", "authorizationGrantTypes", "Lde/justsoftware/authorization/oauth2/client/GrantType;", "getScopeEnums", "getGrantTypeEnums", "deleteClient", "", "generateNewClientSecret", "getClientAndCheckPermissions", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nPublicApiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicApiService.kt\nde/justsoftware/authorization/oauth2/client/PublicApiService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n*L\n1#1,167:1\n1#2:168\n774#3:169\n865#3,2:170\n1557#3:172\n1628#3,3:173\n1557#3:176\n1628#3,3:177\n1557#3:180\n1628#3,3:181\n1557#3:184\n1628#3,3:185\n1557#3:188\n1628#3,3:189\n1557#3:200\n1628#3,3:201\n122#4,8:192\n*S KotlinDebug\n*F\n+ 1 PublicApiService.kt\nde/justsoftware/authorization/oauth2/client/PublicApiService\n*L\n84#1:169\n84#1:170,2\n85#1:172\n85#1:173,3\n118#1:176\n118#1:177,3\n121#1:180\n121#1:181,3\n123#1:184\n123#1:185,3\n126#1:188\n126#1:189,3\n61#1:200\n61#1:201,3\n132#1:192,8\n*E\n"})
public class PublicApiService {
    @NotNull
    private final ExposedRegisteredClientRepository clientRepository;
    @NotNull
    private final PasswordEncoder passwordEncoder;
    @NotNull
    private final PermissionConnector permissionConnector;

    public PublicApiService(@NotNull ExposedRegisteredClientRepository clientRepository, @NotNull PasswordEncoder passwordEncoder, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)clientRepository, (String)"clientRepository");
        Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.clientRepository = clientRepository;
        this.passwordEncoder = passwordEncoder;
        this.permissionConnector = permissionConnector;
    }

    @NotNull
    public PublicApiClientCreateResponse createClient(@NotNull PublicApiClientCreateRequest createRequest, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)createRequest, (String)"createRequest");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (authContext.getTenantId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.permissionConnector.mayManage((ItemId)authContext.getTenantId(), authContext.getProfileId());
        if (!Scope.Companion.getAllPublicApiScopes().containsAll(createRequest.getScopes())) {
            boolean $i$a$-require-PublicApiService$createClient$22 = false;
            String $i$a$-require-PublicApiService$createClient$22 = "Invalid Public API scopes";
            throw new IllegalArgumentException($i$a$-require-PublicApiService$createClient$22.toString());
        }
        UUID clientId = UUID.randomUUID();
        ClientSettings.Builder builder = ClientSettings.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ClientSettings clientSettings = ExposedRegisteredClientRepositoryKt.tenantId((ClientSettings.Builder)builder, (TenantId)authContext.getTenantId()).build();
        TokenSettings tokenSettings = TokenSettings.builder().reuseRefreshTokens(false).accessTokenFormat(OAuth2TokenFormat.REFERENCE).accessTokenTimeToLive(Duration.ofHours(1L)).refreshTokenTimeToLive(Duration.ofDays(1L)).build();
        String rawRandomPassword = new Base64StringKeyGenerator().generateKey();
        RegisteredClient newClient = RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId(clientId.toString()).clientName(((Object)StringsKt.trim((CharSequence)createRequest.getClientName())).toString()).clientSecret(this.passwordEncoder.encode((CharSequence)rawRandomPassword)).clientSettings(clientSettings).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).tokenSettings(tokenSettings).scopes(arg_0 -> PublicApiService.createClient$lambda$1(this, createRequest, arg_0)).redirectUris(arg_0 -> PublicApiService.createClient$lambda$3(createRequest, arg_0)).authorizationGrantTypes(arg_0 -> PublicApiService.createClient$lambda$4(this, createRequest, arg_0)).build();
        Intrinsics.checkNotNull((Object)newClient);
        this.clientRepository.save(newClient);
        String string = newClient.getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientId(...)");
        Intrinsics.checkNotNull((Object)rawRandomPassword);
        String string2 = newClient.getClientName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClientName(...)");
        Set set = newClient.getRedirectUris();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRedirectUris(...)");
        Set set2 = newClient.getAuthorizationGrantTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAuthorizationGrantTypes(...)");
        Set set3 = this.getGrantTypeEnums(set2);
        Set set4 = newClient.getScopes();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"getScopes(...)");
        return new PublicApiClientCreateResponse(string, rawRandomPassword, string2, set, set3, this.getScopeEnums(set4));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PublicApiClient> getAllClients(@NotNull JustAuthorizationContext authContext) {
        List list;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (authContext.getTenantId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.permissionConnector.mayManage((ItemId)authContext.getTenantId(), authContext.getProfileId());
        List list2 = this.clientRepository.findByTenantId(authContext.getTenantId());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = list2;
            boolean $i$f$filter22 = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RegisteredClient client = (RegisteredClient)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = Scope.Companion.getAllPublicApiValues();
                Set set = client.getScopes();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getScopes(...)");
                boolean bl2 = !((Collection)CollectionsKt.intersect((Iterable)iterable2, (Iterable)set)).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Set set;
                String string;
                String string2;
                void it;
                RegisteredClient bl = (RegisteredClient)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getClientId(), (String)"getClientId(...)");
                Intrinsics.checkNotNullExpressionValue((Object)it.getRedirectUris(), (String)"getRedirectUris(...)");
                Intrinsics.checkNotNullExpressionValue((Object)it.getClientName(), (String)"getClientName(...)");
                Set set2 = it.getAuthorizationGrantTypes();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAuthorizationGrantTypes(...)");
                Set set3 = this.getGrantTypeEnums(set2);
                Set set4 = it.getScopes();
                Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"getScopes(...)");
                Set set5 = this.getScopeEnums(set4);
                collection.add(new PublicApiClient(string2, string, set, set3, set5));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public PublicApiClient updateClient(@NotNull String clientId, @NotNull PublicApiClientUpdateRequest updateRequest, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)updateRequest, (String)"updateRequest");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (authContext.getTenantId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.permissionConnector.mayManage((ItemId)authContext.getTenantId(), authContext.getProfileId());
        RegisteredClient origin = this.clientRepository.findByClientId(clientId);
        if (!(origin != null)) {
            boolean bl = false;
            String string = "Public API client with the ID '" + clientId + "' doesn't exist";
            throw new IllegalArgumentException(string.toString());
        }
        String string = origin.getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientId(...)");
        RegisteredClient updatedClient = this.clientRepository.updatePublicApiClient(string, updateRequest);
        String string2 = updatedClient.getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClientId(...)");
        String string3 = updatedClient.getClientName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getClientName(...)");
        Set set = updatedClient.getRedirectUris();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRedirectUris(...)");
        Set set2 = updatedClient.getAuthorizationGrantTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAuthorizationGrantTypes(...)");
        Set set3 = this.getGrantTypeEnums(set2);
        Set set4 = updatedClient.getScopes();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"getScopes(...)");
        return new PublicApiClient(string2, string3, set, set3, this.getScopeEnums(set4));
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getScopesFromEnum(Set<? extends Scope> scopes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scopeEnum;
            Scope scope = (Scope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(scopeEnum.getValue());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<AuthorizationGrantType> getAuthorizationGrantTypesFromEnum(Set<? extends GrantType> authorizationGrantTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = authorizationGrantTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void grantType;
            GrantType grantType2 = (GrantType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AuthorizationGrantType(grantType.getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Scope> getScopeEnums(Set<String> scopes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void enumValue;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Scope.Companion.getEnumFromValue((String)enumValue));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private Set<GrantType> getGrantTypeEnums(Set<AuthorizationGrantType> authorizationGrantTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = authorizationGrantTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void grantClass;
            AuthorizationGrantType authorizationGrantType = (AuthorizationGrantType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = grantClass.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            collection.add(GrantType.Companion.getEnumFromValue(string));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public void deleteClient(@NotNull String clientId, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        RegisteredClient publicApiClient = this.getClientAndCheckPermissions(clientId, authContext);
        Table $this$deleteWhere_u24default$iv = (Table)RegisteredClients.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        RegisteredClients registeredClients = (RegisteredClients)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)RegisteredClients.INSTANCE.getClientId(), (Object)publicApiClient.getClientId());
        companion.where(transaction, table, op, false, limit$iv);
    }

    @NotNull
    public PublicApiClientCreateResponse generateNewClientSecret(@NotNull String clientId, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        RegisteredClient origin = this.getClientAndCheckPermissions(clientId, authContext);
        String rawRandomPassword = new Base64StringKeyGenerator().generateKey();
        String encodedPassword = this.passwordEncoder.encode((CharSequence)rawRandomPassword);
        Intrinsics.checkNotNull((Object)encodedPassword);
        this.clientRepository.updateClientSecret(clientId, encodedPassword);
        String string = origin.getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientId(...)");
        Intrinsics.checkNotNull((Object)rawRandomPassword);
        String string2 = origin.getClientName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClientName(...)");
        Set set = origin.getRedirectUris();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRedirectUris(...)");
        Set set2 = origin.getAuthorizationGrantTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAuthorizationGrantTypes(...)");
        Set set3 = this.getGrantTypeEnums(set2);
        Set set4 = origin.getScopes();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"getScopes(...)");
        return new PublicApiClientCreateResponse(string, rawRandomPassword, string2, set, set3, this.getScopeEnums(set4));
    }

    private RegisteredClient getClientAndCheckPermissions(String clientId, JustAuthorizationContext authContext) {
        RegisteredClient client = this.clientRepository.findByClientId(clientId);
        if (client == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TenantId tenantId = ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client);
        if (tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.permissionConnector.mayManage((ItemId)tenantId, authContext.getProfileId());
        return client;
    }

    private static final void createClient$lambda$1(PublicApiService this$0, PublicApiClientCreateRequest $createRequest, Set it) {
        it.addAll(this$0.getScopesFromEnum($createRequest.getScopes()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void createClient$lambda$3(PublicApiClientCreateRequest $createRequest, Set it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $createRequest.getRedirectUris();
        Set set = it;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)url))).toString());
        }
        set.addAll((List)destination$iv$iv);
    }

    private static final void createClient$lambda$4(PublicApiService this$0, PublicApiClientCreateRequest $createRequest, Set it) {
        it.addAll(this$0.getAuthorizationGrantTypesFromEnum($createRequest.getAuthorizationGrantTypes()));
    }
}

