/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.domain.tenant.model.IdentityProviderConfig;
import de.justsoftware.admin.domain.tenant.persistence.TenantIdpConfigRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.ClientRegistrationId;
import de.justsoftware.admin.id.TenantId;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/admin/domain/tenant/IdpConfigService;", "", "tenantIdpConfigRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantIdpConfigRepository;", "<init>", "(Lde/justsoftware/admin/domain/tenant/persistence/TenantIdpConfigRepository;)V", "getAll", "", "Lde/justsoftware/admin/domain/tenant/model/IdentityProviderConfig;", "upsertIdpConfiguration", "configuration", "getIdpConfiguration", "id", "Lde/justsoftware/admin/id/ClientRegistrationId;", "findIdpConfiguration", "getIdpConfigurationsForTenant", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "removeIdpConfiguration", "", "setAsDefaultIdpForTenant", "removeDefaultIdpForTenant", "admin-service"})
public class IdpConfigService {
    @NotNull
    private final TenantIdpConfigRepository tenantIdpConfigRepo;

    public IdpConfigService(@NotNull TenantIdpConfigRepository tenantIdpConfigRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantIdpConfigRepo, (String)"tenantIdpConfigRepo");
        this.tenantIdpConfigRepo = tenantIdpConfigRepo;
    }

    @NotNull
    public Set<IdentityProviderConfig> getAll() {
        return this.tenantIdpConfigRepo.getAll();
    }

    @NotNull
    public IdentityProviderConfig upsertIdpConfiguration(@NotNull IdentityProviderConfig configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.tenantIdpConfigRepo.upsertIdpConfig(configuration);
        IdentityProviderConfig identityProviderConfig = this.tenantIdpConfigRepo.findOne(configuration.getId());
        if (identityProviderConfig == null) {
            throw new NotFoundException("No IdP configuration found for configId '" + configuration.getId() + "'!");
        }
        return identityProviderConfig;
    }

    @NotNull
    public IdentityProviderConfig getIdpConfiguration(@NotNull ClientRegistrationId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        IdentityProviderConfig identityProviderConfig = this.findIdpConfiguration(id);
        if (identityProviderConfig == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return identityProviderConfig;
    }

    @Nullable
    public IdentityProviderConfig findIdpConfiguration(@NotNull ClientRegistrationId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.tenantIdpConfigRepo.findOne(id);
    }

    @NotNull
    public Set<IdentityProviderConfig> getIdpConfigurationsForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantIdpConfigRepo.getAllByTenant(tenantId);
    }

    public void removeIdpConfiguration(@NotNull ClientRegistrationId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.tenantIdpConfigRepo.deleteOne(id);
    }

    @NotNull
    public Set<IdentityProviderConfig> setAsDefaultIdpForTenant(@NotNull ClientRegistrationId id, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantIdpConfigRepo.setAsDefaultForTenant(id, tenantId);
        return this.tenantIdpConfigRepo.getAllByTenant(tenantId);
    }

    @NotNull
    public Set<IdentityProviderConfig> removeDefaultIdpForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantIdpConfigRepo.removeDefaultIdpForTenant(tenantId);
        return this.tenantIdpConfigRepo.getAllByTenant(tenantId);
    }
}

