/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.config.ZookeeperConfig;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.domain.appsettings.UpdateExternalApp;
import de.justsoftware.admin.domain.appsettings.model.AppHomeScreenPosition;
import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.AppPlacementType;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppPlacement;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.id.CoreAppId;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ExternalAppId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.mybatis.mapper.AppHomeScreenPositionMapper;
import de.justsoftware.admin.mybatis.mapper.AppPlacementMapper;
import de.justsoftware.admin.mybatis.mapper.CoreAppSettingsMapper;
import de.justsoftware.admin.mybatis.mapper.ExternalAppSettingsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J}\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010&2\u0010\b\u0002\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020\u00162\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u00106\u001a\u00020\u001e2\u0006\u0010#\u001a\u000205H\u0016J\u0010\u00107\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00108\u001a\u00020\u00182\u0006\u0010#\u001a\u000209H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J\"\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120=0<2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00120=2\u0006\u0010?\u001a\u000205H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010D\u001a\u00020\u00162\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u001eH\u0012J1\u0010H\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010&2\u0006\u0010I\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0012\u00a2\u0006\u0002\u0010JR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "", "coreAppRepo", "Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;", "appHomeScreenPositionRepo", "Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;", "appPlacementRepo", "Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "externalAppSettingsRepo", "Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;", "zookeeperConfig", "Lde/justsoftware/admin/config/ZookeeperConfig;", "<init>", "(Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;Lde/justsoftware/admin/config/ZookeeperConfig;)V", "createDefaultAppPlacements", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "createExternalApp", "", "externalAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "placements", "", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "createInitialApps", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "updateCoreApp", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "id", "Lde/justsoftware/admin/id/CoreAppId;", "active", "", "appColor", "Lde/justsoftware/admin/model/HexColor;", "homeScreenAppColor", "iconId", "Lde/justsoftware/admin/id/DocumentId;", "removeIcon", "placementAdds", "placementRemoves", "(Lde/justsoftware/admin/id/CoreAppId;Lde/justsoftware/admin/id/ProfileId;Ljava/lang/Boolean;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;)Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "updateExternalApp", "update", "Lde/justsoftware/admin/domain/appsettings/UpdateExternalApp;", "saveAppPositions", "appIds", "Lde/justsoftware/admin/id/AppId;", "getApp", "getCoreApp", "getExternalApp", "Lde/justsoftware/admin/id/ExternalAppId;", "getAppsByTenant", "getAppsWithPlacements", "", "", "getPlacements", "appId", "getLastPosition", "", "deleteExternalApp", "app", "deleteAppPlacements", "userId", "Lde/justsoftware/admin/id/UserId;", "upsertAppPosition", "syncIconChangesWithDrive", "origin", "(Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Lde/justsoftware/admin/domain/appsettings/model/AppSettings;Lde/justsoftware/admin/id/ProfileId;)V", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1563#2:303\n1634#2,3:304\n1563#2:307\n1634#2,3:308\n1869#2,2:311\n1869#2,2:313\n1563#2:315\n1634#2,3:316\n1563#2:319\n1634#2,3:320\n1563#2:323\n1634#2,3:324\n1869#2,2:327\n1869#2,2:329\n1869#2,2:331\n1869#2,2:333\n1056#2:335\n1563#2:336\n1634#2,3:337\n1573#2:340\n1604#2,4:341\n1869#2,2:345\n1056#2:347\n1285#2,2:348\n1299#2,4:350\n1#3:354\n*S KotlinDebug\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n*L\n53#1:303\n53#1:304,3\n63#1:307\n63#1:308,3\n73#1:311,2\n90#1:313,2\n108#1:315\n108#1:316,3\n109#1:319\n109#1:320,3\n120#1:323\n120#1:324,3\n154#1:327,2\n155#1:329,2\n182#1:331,2\n183#1:333,2\n203#1:335\n204#1:336\n204#1:337,3\n213#1:340\n213#1:341,4\n214#1:345,2\n239#1:347\n242#1:348,2\n242#1:350,4\n*E\n"})
public class AppSettingsService {
    @NotNull
    private final CoreAppSettingsMapper coreAppRepo;
    @NotNull
    private final AppHomeScreenPositionMapper appHomeScreenPositionRepo;
    @NotNull
    private final AppPlacementMapper appPlacementRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final ExternalAppSettingsMapper externalAppSettingsRepo;
    @NotNull
    private final ZookeeperConfig zookeeperConfig;

    public AppSettingsService(@NotNull CoreAppSettingsMapper coreAppRepo, @NotNull AppHomeScreenPositionMapper appHomeScreenPositionRepo, @NotNull AppPlacementMapper appPlacementRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull ExternalAppSettingsMapper externalAppSettingsRepo, @NotNull ZookeeperConfig zookeeperConfig) {
        Intrinsics.checkNotNullParameter((Object)coreAppRepo, (String)"coreAppRepo");
        Intrinsics.checkNotNullParameter((Object)appHomeScreenPositionRepo, (String)"appHomeScreenPositionRepo");
        Intrinsics.checkNotNullParameter((Object)appPlacementRepo, (String)"appPlacementRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)externalAppSettingsRepo, (String)"externalAppSettingsRepo");
        Intrinsics.checkNotNullParameter((Object)zookeeperConfig, (String)"zookeeperConfig");
        this.coreAppRepo = coreAppRepo;
        this.appHomeScreenPositionRepo = appHomeScreenPositionRepo;
        this.appPlacementRepo = appPlacementRepo;
        this.driveApiConnector = driveApiConnector;
        this.externalAppSettingsRepo = externalAppSettingsRepo;
        this.zookeeperConfig = zookeeperConfig;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppPlacement> createDefaultAppPlacements(@NotNull UserGroup userGroup) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        AppPlacementType appPlacementType;
        UserGroupId userGroupId;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        TenantId tenantId = userGroup.getTenantId();
        Iterable iterable = CoreAppPlacement.Companion.getAppsWithDefaultPlacements();
        boolean $i$f$map22 = false;
        void var6_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CoreAppId coreAppId = CoreAppId.Companion.fromAppAndTenantId((CoreApp)it, tenantId);
            userGroupId = userGroup.getId();
            appPlacementType = AppPlacementType.MANDATORY;
            collection.add(new CoreAppPlacement(coreAppId, (UserId)userGroupId, appPlacementType, tenantId));
        }
        List coreAppPlacements = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalAppSettings bl = (ExternalAppSettings)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            userGroupId = it.getId();
            appPlacementType = userGroup.getId();
            AppPlacementType appPlacementType2 = AppPlacementType.RECOMMENDED;
            collection.add(new AppPlacement((AppId)userGroupId, (UserId)appPlacementType, appPlacementType2, tenantId));
        }
        List externalAppPlacements = (List)destination$iv$iv2;
        List placements = CollectionsKt.plus((Collection)coreAppPlacements, (Iterable)externalAppPlacements);
        Iterable $this$forEach$iv = placements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        return placements;
    }

    public void createExternalApp(@NotNull ExternalAppSettings externalAppSettings, @NotNull Collection<? extends AppPlacement> placements, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)externalAppSettings, (String)"externalAppSettings");
        Intrinsics.checkNotNullParameter(placements, (String)"placements");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.appHomeScreenPositionRepo.upsert(new AppHomeScreenPosition((AppId)externalAppSettings.getId(), externalAppSettings.getPosition(), externalAppSettings.getTenantId()));
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)placements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        DocumentId documentId = externalAppSettings.getIconId();
        if (documentId != null) {
            DocumentId it = documentId;
            boolean bl = false;
            this.driveApiConnector.addFile(it, externalAppSettings.getTenantId(), profileId);
        }
        this.externalAppSettingsRepo.upsert(externalAppSettings);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> createInitialApps(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CoreAppSettings it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv2 = (Iterable)CoreApp.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CoreAppSettings.Companion.withDefaults$default((CoreAppSettings.Companion)CoreAppSettings.Companion, (TenantId)tenantId, (CoreApp)it, (boolean)false, null, null, null, null, null, (int)0, (int)508, null));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (CoreAppSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            this.coreAppRepo.upsertCoreApp(it);
            this.upsertAppPosition((AppSettings)it);
            collection.add(it);
        }
        List coreApps = (List)destination$iv$iv;
        Object $i$f$map2 = new ExternalAppSettings[]{ExternalAppSettings.Companion.withDefaultsForMeetApp$default((ExternalAppSettings.Companion)ExternalAppSettings.Companion, (TenantId)tenantId, (String)this.zookeeperConfig.getHost(), (boolean)false, (int)0, (int)12, null), ExternalAppSettings.Companion.withDefaultsForSupportApp(tenantId), ExternalAppSettings.Companion.withDefaultsForWebsiteApp(tenantId)};
        $i$f$map2 = CollectionsKt.listOf((Object[])$i$f$map2);
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ExternalAppSettings bl = (ExternalAppSettings)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            this.externalAppSettingsRepo.upsert((ExternalAppSettings)it2);
            this.upsertAppPosition((AppSettings)it2);
            collection.add(it2);
        }
        List externalApps = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)coreApps, (Iterable)externalApps);
    }

    @NotNull
    public CoreAppSettings updateCoreApp(@NotNull CoreAppId id, @NotNull ProfileId profileId, @Nullable Boolean active, @Nullable HexColor appColor, @Nullable HexColor homeScreenAppColor, @Nullable DocumentId iconId, @Nullable Boolean removeIcon, @Nullable List<? extends AppPlacement> placementAdds, @Nullable List<? extends AppPlacement> placementRemoves) {
        AppPlacement it;
        Object object;
        Object object2;
        Object object3;
        HexColor hexColor;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        CoreAppSettings origin = this.getCoreApp(id);
        Boolean bl = active;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getActive();
        HexColor hexColor2 = appColor;
        if (hexColor2 == null) {
            hexColor2 = hexColor = origin.getAppColor();
        }
        if ((object3 = homeScreenAppColor) == null) {
            object3 = object2 = origin.getHomeScreenAppColor();
        }
        if ((object = iconId) == null) {
            object = Intrinsics.areEqual((Object)removeIcon, (Object)true) ? null : origin.getIconId();
        }
        DocumentId documentId = object;
        CoreAppSettings updated = CoreAppSettings.copy$default((CoreAppSettings)origin, null, (boolean)bl2, (DocumentId)documentId, null, null, null, (HexColor)hexColor, (HexColor)object2, (int)0, (int)313, null);
        List<? extends AppPlacement> list = placementRemoves;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl3 = false;
                this.appPlacementRepo.delete(it);
            }
        }
        List<? extends AppPlacement> list2 = placementAdds;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl4 = false;
                this.appPlacementRepo.upsert(it);
            }
        }
        this.syncIconChangesWithDrive(iconId, removeIcon, (AppSettings)origin, profileId);
        this.coreAppRepo.upsertCoreApp(updated);
        return this.getCoreApp(updated.getId());
    }

    public static /* synthetic */ CoreAppSettings updateCoreApp$default(AppSettingsService appSettingsService, CoreAppId coreAppId, ProfileId profileId, Boolean bl, HexColor hexColor, HexColor hexColor2, DocumentId documentId, Boolean bl2, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateCoreApp");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            hexColor = null;
        }
        if ((n & 0x10) != 0) {
            hexColor2 = null;
        }
        if ((n & 0x20) != 0) {
            documentId = null;
        }
        if ((n & 0x40) != 0) {
            bl2 = null;
        }
        if ((n & 0x80) != 0) {
            list = null;
        }
        if ((n & 0x100) != 0) {
            list2 = null;
        }
        return appSettingsService.updateCoreApp(coreAppId, profileId, bl, hexColor, hexColor2, documentId, bl2, list, list2);
    }

    @NotNull
    public ExternalAppSettings updateExternalApp(@NotNull UpdateExternalApp update) {
        AppPlacement it;
        Iterable $this$forEach$iv;
        String string;
        Object object;
        Object object2;
        HexColor hexColor;
        HexColor hexColor2;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        ExternalAppSettings origin = this.getExternalApp(update.getId());
        Boolean bl = update.getActive();
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getActive();
        Collection collection2 = update.getClients();
        if (collection2 == null || (collection2 = CollectionsKt.toSet((Iterable)collection2)) == null) {
            collection2 = collection = origin.getClients();
        }
        if ((hexColor2 = update.getHomeScreenAppColor()) == null) {
            hexColor2 = hexColor = origin.getHomeScreenAppColor();
        }
        if ((object2 = update.getIconId()) == null) {
            object2 = object = Intrinsics.areEqual((Object)update.getRemoveIcon(), (Object)true) ? null : origin.getIconId();
        }
        if ((string = update.getName()) == null) {
            string = origin.getName();
        }
        String string2 = string;
        String string3 = update.getUrl() != null ? ExternalAppSettings.Companion.validateUrl(update.getUrl()) : origin.getUrl();
        ExternalAppSettings.OpenUrlIn openUrlIn = update.getOpenUrlIn();
        if (openUrlIn == null) {
            openUrlIn = origin.getOpenUrlIn();
        }
        ExternalAppSettings.OpenUrlIn openUrlIn2 = openUrlIn;
        ExternalAppSettings updated = ExternalAppSettings.copy$default((ExternalAppSettings)origin, null, (boolean)bl2, (DocumentId)object, (String)string2, (ExternalAppSettings.OpenUrlIn)openUrlIn2, (String)string3, (HexColor)hexColor, (int)0, null, (Set)collection, (int)385, null);
        List list = update.getPlacementRemoves();
        if (list != null) {
            $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl3 = false;
                this.appPlacementRepo.delete(it);
            }
        }
        List list2 = update.getPlacementAdds();
        if (list2 != null) {
            $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl4 = false;
                this.appPlacementRepo.upsert(it);
            }
        }
        this.syncIconChangesWithDrive(update.getIconId(), update.getRemoveIcon(), (AppSettings)origin, update.getProfileId());
        this.externalAppSettingsRepo.upsert(updated);
        return this.getExternalApp(update.getId());
    }

    /*
     * WARNING - void declaration
     */
    public void saveAppPositions(@NotNull List<? extends AppId> appIds, @NotNull TenantId tenantId) {
        void $this$forEach$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set coreApps = this.coreAppRepo.getCoreAppsByTenantId(tenantId);
        Set externalApps = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        Iterable iterable = SetsKt.plus((Set)coreApps, (Iterable)externalApps);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$map22 = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppSettings appSettings = (AppSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List originAppIds = (List)destination$iv$iv;
        List allAppIds = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)appIds, (Iterable)originAppIds));
        this.appHomeScreenPositionRepo.deleteAllByTenantId(tenantId);
        Iterable $i$f$map22 = allAppIds;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void appId;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AppId appId2 = (AppId)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new AppHomeScreenPosition((AppId)appId, (int)index, tenantId));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppHomeScreenPosition it = (AppHomeScreenPosition)element$iv;
            boolean bl = false;
            this.appHomeScreenPositionRepo.upsert(it);
        }
    }

    @NotNull
    public AppSettings getApp(@NotNull AppId id) {
        AppSettings appSettings;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AppId appId = id;
        if (appId instanceof CoreAppId) {
            appSettings = (AppSettings)this.getCoreApp((CoreAppId)id);
        } else if (appId instanceof ExternalAppId) {
            appSettings = (AppSettings)this.getExternalApp((ExternalAppId)id);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return appSettings;
    }

    @NotNull
    public CoreAppSettings getCoreApp(@NotNull CoreAppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CoreAppSettings coreAppSettings = this.coreAppRepo.findCoreApp(id);
        if (coreAppSettings == null) {
            boolean bl = false;
            throw new NotFoundException("No CoreAppSettings with id: '" + id + "' found");
        }
        return coreAppSettings;
    }

    @NotNull
    public ExternalAppSettings getExternalApp(@NotNull ExternalAppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ExternalAppSettings externalAppSettings = this.externalAppSettingsRepo.findExternalAppSettings(id);
        if (externalAppSettings == null) {
            boolean bl = false;
            throw new NotFoundException("No ExternalAppSettings with id: '" + id + "' found");
        }
        return externalAppSettings;
    }

    @NotNull
    public List<AppSettings> getAppsByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = SetsKt.plus((Set)this.coreAppRepo.getCoreAppsByTenantId(tenantId), (Iterable)this.externalAppSettingsRepo.getAllByTenantId(tenantId));
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<AppSettings, Set<AppPlacement>> getAppsWithPlacements(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$associateWith$iv = this.getAppsByTenant(tenantId);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            AppSettings appSettings = (AppSettings)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Set set = this.getPlacements(it.getId());
            map.put(t, set);
        }
        return result$iv;
    }

    @NotNull
    public Set<AppPlacement> getPlacements(@NotNull AppId appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        return this.appPlacementRepo.getByAppId(appId);
    }

    public int getLastPosition(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.appHomeScreenPositionRepo.getLastPosition(tenantId);
    }

    public void deleteExternalApp(@NotNull ExternalAppSettings app, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.appPlacementRepo.deleteByAppId((AppId)app.getId());
        this.externalAppSettingsRepo.deleteById(app.getId());
        this.driveApiConnector.deleteFile(app.getIconId(), profileId);
        this.saveAppPositions(CollectionsKt.emptyList(), app.getTenantId());
    }

    public void deleteAppPlacements(@NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.appPlacementRepo.deleteByUserId(userId);
    }

    private void upsertAppPosition(AppSettings app) {
        AppHomeScreenPosition it = new AppHomeScreenPosition(app.getId(), app.getPosition(), app.getTenantId());
        boolean bl = false;
        this.appHomeScreenPositionRepo.upsert(it);
    }

    private void syncIconChangesWithDrive(DocumentId iconId, Boolean removeIcon, AppSettings origin, ProfileId profileId) {
        if (iconId != null && !Intrinsics.areEqual((Object)iconId, (Object)origin.getIconId())) {
            this.driveApiConnector.replaceFile(origin.getIconId(), iconId, origin.getTenantId(), profileId);
        } else if (Intrinsics.areEqual((Object)removeIcon, (Object)true)) {
            this.driveApiConnector.deleteFile(origin.getIconId(), profileId);
        }
    }
}

