/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.toro;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.admin.connector.toro.ToroImportConnector;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0017H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/admin/connector/toro/ToroImportConnector;", "", "toroInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "authInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "authorizedRestClient", "Lorg/springframework/web/client/RestClient;", "importExternalPersons", "Lde/justsoftware/admin/connector/toro/ToroImportConnector$ImportResult;", "importExternalUserGroups", "handleToroError", "Lorg/springframework/web/client/RestClient$ResponseSpec;", "ImportResult", "ToroException", "admin-service"})
@SourceDebugExtension(value={"SMAP\nToroImportConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToroImportConnector.kt\nde/justsoftware/admin/connector/toro/ToroImportConnector\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n52#2:74\n52#2:75\n1#3:76\n*S KotlinDebug\n*F\n+ 1 ToroImportConnector.kt\nde/justsoftware/admin/connector/toro/ToroImportConnector\n*L\n31#1:74\n39#1:75\n*E\n"})
public class ToroImportConnector {
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;
    @NotNull
    private final RestClient authorizedRestClient;

    public ToroImportConnector(@Value(value="${just.toro.internal.host.url}") @NotNull String toroInternalUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor authInterceptor, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(ToroImportConnector.class);
        RestClient restClient = restClientBuilder.baseUrl(toroInternalUrl).requestInterceptor(authInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.authorizedRestClient = restClient;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public ImportResult importExternalPersons() {
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)this.authorizedRestClient.post().uri("/import/externalPersons", new Object[0])).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$requiredBody$iv = this.handleToroError(responseSpec);
        boolean $i$f$requiredBody = false;
        Object object = $this$requiredBody$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            throw new NoSuchElementException("Response body is required");
        }
        return (ImportResult)object;
    }

    @NotNull
    public ImportResult importExternalUserGroups() {
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)this.authorizedRestClient.post().uri("/import/externalUserGroups", new Object[0])).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$requiredBody$iv = this.handleToroError(responseSpec);
        boolean $i$f$requiredBody = false;
        Object object = $this$requiredBody$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            throw new NoSuchElementException("Response body is required");
        }
        return (ImportResult)object;
    }

    @NotNull
    public RestClient.ResponseSpec handleToroError(@NotNull RestClient.ResponseSpec $this$handleToroError) {
        Intrinsics.checkNotNullParameter((Object)$this$handleToroError, (String)"<this>");
        RestClient.ResponseSpec responseSpec = $this$handleToroError.onStatus(ToroImportConnector::handleToroError$lambda$0, (arg_0, arg_1) -> ToroImportConnector.handleToroError$lambda$3(this, $this$handleToroError, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        return responseSpec;
    }

    private static final boolean handleToroError$lambda$0(HttpStatusCode status) {
        return status.isError();
    }

    private static final void handleToroError$lambda$3(ToroImportConnector this$0, RestClient.ResponseSpec $this_handleToroError, HttpRequest httpRequest, ClientHttpResponse response) {
        Object $this$handleToroError_u24lambda_u243_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        InputStream inputStream = response.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getBody(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Object object = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        String responseBody = TextStreamsKt.readText((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)));
        this$0.logger.error("toro error. statusCode: " + response.getStatusCode() + ", responseBody: " + responseBody);
        object = $this_handleToroError;
        try {
            $this$handleToroError_u24lambda_u243_u24lambda_u241 = object;
            boolean bl = false;
            $this$handleToroError_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)this$0.getObjectMapper().readTree(responseBody).get("data").get("message").asText());
        }
        catch (Throwable bl) {
            $this$handleToroError_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$handleToroError_u24lambda_u243_u24lambda_u241;
        $this$handleToroError_u24lambda_u243_u24lambda_u241 = "";
        object = Result.isFailure-impl((Object)object) ? $this$handleToroError_u24lambda_u243_u24lambda_u241 : object;
        String it = (String)object;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string = (String)(!StringsKt.isBlank((CharSequence)it) ? object : null);
        if (string == null) {
            string = "Unknown error, see logs for more details.";
        }
        String message = string;
        throw new ToroException(message);
    }
}

