/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.auth.AuthConnector;
import de.justsoftware.admin.connector.auth.PublicApiClient;
import de.justsoftware.admin.connector.auth.PublicApiClientWithSecret;
import de.justsoftware.admin.graphql.dataFetchers.PublicApiClientFetcherKt;
import de.justsoftware.admin.graphql.dataFetchers.TenantFetcherKt;
import de.justsoftware.admin.graphql.generated.types.AddPublicApiClientInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.UpdatePublicApiClientInput;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\r\u001a\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\u0013\u001a\u00020\n2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\u0016\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/PublicApiClientFetcher;", "", "authConnector", "Lde/justsoftware/admin/connector/auth/AuthConnector;", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "<init>", "(Lde/justsoftware/admin/connector/auth/AuthConnector;Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "getAllClients", "", "Lde/justsoftware/admin/graphql/generated/types/PublicApiClient;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "addClient", "input", "Lde/justsoftware/admin/graphql/generated/types/AddPublicApiClientInput;", "updateClient", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "Lde/justsoftware/admin/graphql/generated/types/UpdatePublicApiClientInput;", "updateClientSecret", "id", "", "deleteClient", "admin-service"})
@SourceDebugExtension(value={"SMAP\nPublicApiClientFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicApiClientFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/PublicApiClientFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1563#2:88\n1634#2,3:89\n*S KotlinDebug\n*F\n+ 1 PublicApiClientFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/PublicApiClientFetcher\n*L\n31#1:88\n31#1:89,3\n*E\n"})
public class PublicApiClientFetcher {
    @NotNull
    private final AuthConnector authConnector;
    @NotNull
    private final TenantApplicationService tenantApplicationService;

    public PublicApiClientFetcher(@NotNull AuthConnector authConnector, @NotNull TenantApplicationService tenantApplicationService) {
        Intrinsics.checkNotNullParameter((Object)authConnector, (String)"authConnector");
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        this.authConnector = authConnector;
        this.tenantApplicationService = tenantApplicationService;
    }

    /*
     * WARNING - void declaration
     */
    @DgsData(parentType="Tenant", field="publicApiClients")
    @NotNull
    public List<de.justsoftware.admin.graphql.generated.types.PublicApiClient> getAllClients(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        Iterable $this$map$iv = this.authConnector.getPublicApiClients();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PublicApiClient publicApiClient = (PublicApiClient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PublicApiClientFetcherKt.access$toGql((PublicApiClient)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsMutation(field="addPublicApiClient")
    @NotNull
    public de.justsoftware.admin.graphql.generated.types.PublicApiClient addClient(@InputArgument @NotNull AddPublicApiClientInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        return PublicApiClientFetcherKt.access$toGql((PublicApiClientWithSecret)this.authConnector.createPublicApiClient(input));
    }

    @DgsMutation(field="updatePublicApiClient")
    @NotNull
    public Tenant updateClient(@InputArgument @NotNull UpdatePublicApiClientInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        this.authConnector.updatePublicApiClient(input);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="updatePublicApiClientSecret")
    @NotNull
    public de.justsoftware.admin.graphql.generated.types.PublicApiClient updateClientSecret(@InputArgument @NotNull String id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        return PublicApiClientFetcherKt.access$toGql((PublicApiClientWithSecret)this.authConnector.updatePublicApiClientSecret(id));
    }

    @DgsMutation(field="deletePublicApiClient")
    @NotNull
    public Tenant deleteClient(@InputArgument @NotNull String id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        this.authConnector.deletePublicApiClient(id);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }
}

