/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.kafka;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.domain.appsettings.AppSettingsPermissionService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppPlacement;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J*\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0 H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;", "", "appSettingsPermissionService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "<init>", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/user/UserService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "deleteProfileFromKafka", "Lde/justsoftware/admin/id/ProfileId;", "profileId", "deleteUserGroupFromKafka", "Lde/justsoftware/admin/id/UserGroupId;", "userGroupId", "saveProfileFromKafka", "Lde/justsoftware/admin/domain/user/model/Profile;", "profile", "saveUserGroupFromKafka", "", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "initPermissionsForAllTenantUsersGroup", "allTenantUsersGroup", "appsWithPlacements", "", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nKafkaConsumerApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConsumerApplicationService.kt\nde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1563#2:133\n1634#2,3:134\n1285#2,2:137\n1299#2,2:139\n774#2:141\n865#2,2:142\n1302#2:144\n1563#2:145\n1634#2,3:146\n*S KotlinDebug\n*F\n+ 1 KafkaConsumerApplicationService.kt\nde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService\n*L\n90#1:133\n90#1:134,3\n91#1:137,2\n91#1:139,2\n91#1:141\n91#1:142,2\n91#1:144\n116#1:145\n116#1:146,3\n*E\n"})
public class KafkaConsumerApplicationService {
    @NotNull
    private final AppSettingsPermissionService appSettingsPermissionService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final UserService userService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TransactionSupport transactionSupport;

    public KafkaConsumerApplicationService(@NotNull AppSettingsPermissionService appSettingsPermissionService, @NotNull TenantPermissionService tenantPermissionService, @NotNull AppSettingsService appSettingsService, @NotNull UserService userService, @NotNull Publisher publisher, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)appSettingsPermissionService, (String)"appSettingsPermissionService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.appSettingsPermissionService = appSettingsPermissionService;
        this.tenantPermissionService = tenantPermissionService;
        this.appSettingsService = appSettingsService;
        this.userService = userService;
        this.publisher = publisher;
        this.transactionSupport = transactionSupport;
    }

    @Transactional
    @NotNull
    public ProfileId deleteProfileFromKafka(@NotNull ProfileId profileId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            Profile profile = this.userService.findProfile(profileId);
            if (profile == null) break block0;
            Profile it = profile;
            boolean bl = false;
            this.appSettingsService.deleteAppPlacements((UserId)profileId);
            List deletedAppPermissions = this.appSettingsPermissionService.deletePermissions((UserId)profileId);
            List tenantManagerPermissions = this.tenantPermissionService.deleteAllFor((UserId)profileId);
            this.userService.deleteProfile(profileId);
            this.transactionSupport.afterCommit(() -> KafkaConsumerApplicationService.deleteProfileFromKafka$lambda$1$lambda$0(this, deletedAppPermissions, tenantManagerPermissions));
        }
        return profileId;
    }

    @Transactional
    @NotNull
    public UserGroupId deleteUserGroupFromKafka(@NotNull UserGroupId userGroupId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
            UserGroup userGroup = this.userService.findUserGroup(userGroupId);
            if (userGroup == null) break block0;
            UserGroup it = userGroup;
            boolean bl = false;
            this.appSettingsService.deleteAppPlacements((UserId)userGroupId);
            List deletedAppPermissions = this.appSettingsPermissionService.deletePermissions((UserId)userGroupId);
            List tenantManagerPermissions = this.tenantPermissionService.deleteAllFor((UserId)userGroupId);
            this.userService.deleteUserGroup(userGroupId);
            this.transactionSupport.afterCommit(() -> KafkaConsumerApplicationService.deleteUserGroupFromKafka$lambda$3$lambda$2(this, it, deletedAppPermissions, tenantManagerPermissions));
        }
        return userGroupId;
    }

    @NotNull
    public Profile saveProfileFromKafka(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.userService.saveProfile(profile);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void saveUserGroupFromKafka(@NotNull UserGroup userGroup) {
        boolean isNew;
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        boolean bl = isNew = this.userService.findUserGroup(userGroup.getId()) == null;
        if (isNew) {
            if (userGroup.isAllTenantUsersGroup()) {
                Object object;
                void $this$mapTo$iv$iv;
                List placements = this.appSettingsService.createDefaultAppPlacements(userGroup);
                Iterable $this$map$iv = placements;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AppPlacement appPlacement = (AppPlacement)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    object.add(this.appSettingsService.getApp(it.getAppId()));
                }
                List apps = (List)destination$iv$iv;
                Iterable $this$associateWith$iv = apps;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void $this$filterTo$iv$iv;
                    AppSettings bl2 = (AppSettings)element$iv$iv;
                    Object t = element$iv$iv;
                    object = result$iv;
                    boolean bl3 = false;
                    Iterable $this$filter$iv = placements;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        void app;
                        AppPlacement it = (AppPlacement)element$iv$iv2;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getAppId(), (Object)app.getId())) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    List list = (List)destination$iv$iv2;
                    object.put(t, list);
                }
                Map appsWithPlacements = result$iv;
                this.initPermissionsForAllTenantUsersGroup(userGroup, appsWithPlacements);
            } else {
                this.transactionSupport.afterCommit(() -> KafkaConsumerApplicationService.saveUserGroupFromKafka$lambda$7(this, userGroup));
            }
        }
        this.userService.saveUserGroup(userGroup);
    }

    /*
     * WARNING - void declaration
     */
    private void initPermissionsForAllTenantUsersGroup(UserGroup allTenantUsersGroup, Map<AppSettings, ? extends Collection<? extends AppPlacement>> appsWithPlacements) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set tenantPermissions = SetsKt.setOf((Object)new TenantPermission(allTenantUsersGroup.getTenantId(), (UserId)allTenantUsersGroup.getId(), Role.USE_ALL_TENANT_USERS_GROUP));
        Object[] objectArray = (Object[])CoreAppPlacement.Companion.getAppsWithDefaultPlacements();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CoreApp coreApp = (CoreApp)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AppPermission(allTenantUsersGroup.getTenantId(), (CoreApp)it, (UserId)allTenantUsersGroup.getId(), Role.READER));
        }
        objectArray = new AppPermission[]{new AppPermission(allTenantUsersGroup.getTenantId(), CoreApp.CHAT, (UserId)allTenantUsersGroup.getId(), Role.CHAT_CREATE_ONE_TO_ONE), new AppPermission(allTenantUsersGroup.getTenantId(), CoreApp.CHAT, (UserId)allTenantUsersGroup.getId(), Role.CHAT_CREATE_MANY_TO_MANY)};
        List appPermissions = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object[])objectArray));
        this.tenantPermissionService.save(tenantPermissions);
        AppSettingsPermissionService.updatePermissions$default((AppSettingsPermissionService)this.appSettingsPermissionService, (Collection)appPermissions, null, (int)2, null);
        this.transactionSupport.afterCommit(() -> KafkaConsumerApplicationService.initPermissionsForAllTenantUsersGroup$lambda$9(this, allTenantUsersGroup, tenantPermissions, appPermissions, appsWithPlacements));
    }

    private static final Unit deleteProfileFromKafka$lambda$1$lambda$0(KafkaConsumerApplicationService this$0, List $deletedAppPermissions, List $tenantManagerPermissions) {
        this$0.publisher.publishDeletedProfile($deletedAppPermissions, $tenantManagerPermissions);
        return Unit.INSTANCE;
    }

    private static final Unit deleteUserGroupFromKafka$lambda$3$lambda$2(KafkaConsumerApplicationService this$0, UserGroup $it, List $deletedAppPermissions, List $tenantManagerPermissions) {
        this$0.publisher.publishDeletedUserGroup($it, $deletedAppPermissions, $tenantManagerPermissions);
        return Unit.INSTANCE;
    }

    private static final Unit saveUserGroupFromKafka$lambda$7(KafkaConsumerApplicationService this$0, UserGroup $userGroup) {
        Publisher.publishNewUserGroup$default((Publisher)this$0.publisher, (UserGroup)$userGroup, null, null, null, (int)14, null);
        return Unit.INSTANCE;
    }

    private static final Unit initPermissionsForAllTenantUsersGroup$lambda$9(KafkaConsumerApplicationService this$0, UserGroup $allTenantUsersGroup, Set $tenantPermissions, List $appPermissions, Map $appsWithPlacements) {
        this$0.publisher.publishNewUserGroup($allTenantUsersGroup, (Collection)$tenantPermissions, (Collection)$appPermissions, $appsWithPlacements);
        return Unit.INSTANCE;
    }
}

