import hashlib
import base64
from binascii import unhexlify

def generate_solr_password_hash(salt, password):
    """
    Generiert den vollständigen Solr Passwort-Hash nach folgendem Prozess:
    1. Kombiniert Salt + Passwort
    2. Erstellt SHA256-Hash (Hex)
    3. Konvertiert Hex in Binärdaten
    4. Erstellt zweiten SHA256-Hash aus Binärdaten
    5. Konvertiert diesen in Base64
    6. Kodiert den Salt ebenfalls in Base64
    """
    try:
        # Kombiniere Salt + Passwort
        combined = salt + password

        # Erster SHA256-Hash
        first_hash = hashlib.sha256(combined.encode()).hexdigest()
        first_hash_binary = unhexlify(first_hash)  # Simuliert `xxd -r -p`

        # Zweiter SHA256-Hash
        second_hash = hashlib.sha256(first_hash_binary).hexdigest()
        second_hash_binary = unhexlify(second_hash)

        # Base64-Kodierung des finalen Passwort-Hashes
        final_password_hash = base64.b64encode(second_hash_binary).decode()

        # Base64-Kodierung des Salt
        salt_base64 = base64.b64encode(salt.encode()).decode()

        return f"{final_password_hash} {salt_base64}"
    except Exception as e:
        return f"Error generating password hash: {str(e)}"

# Registriere den Filter in Ansible
class FilterModule(object):
    def filters(self):
        return {
            'generate_solr_password_hash': generate_solr_password_hash
        }
