/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.monitoring;

import de.justsoftware.notificationservice.business.InternalPeopleService;
import de.justsoftware.notificationservice.business.UserGroupMemberService;
import de.justsoftware.notificationservice.model.ClusterPosition;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J2\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\b\b\u0002\u0010#\u001a\u00020\u001bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u000f0\u000fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/notificationservice/monitoring/UserGroupMembershipChecksumHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "internalPeopleService", "Lde/justsoftware/notificationservice/business/InternalPeopleService;", "userGroupMemberService", "Lde/justsoftware/notificationservice/business/UserGroupMemberService;", "clock", "Ljava/time/Clock;", "clusterPosition", "Lde/justsoftware/notificationservice/model/ClusterPosition;", "<init>", "(Lde/justsoftware/notificationservice/business/InternalPeopleService;Lde/justsoftware/notificationservice/business/UserGroupMemberService;Ljava/time/Clock;Lde/justsoftware/notificationservice/model/ClusterPosition;)V", "lastChecksum", "", "lastChecksumDate", "Ljava/time/Instant;", "cacheCheckUntil", "kotlin.jvm.PlatformType", "lastStatus", "Lorg/springframework/boot/actuate/health/Status;", "lastDetailKey", "lastDetailValue", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "isChecksumUnchangedSince", "", "checksum", "duration", "Ljava/time/temporal/TemporalAmount;", "setStatus", "status", "detailKey", "detailValue", "shouldCache", "notification-service"})
public class UserGroupMembershipChecksumHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final InternalPeopleService internalPeopleService;
    @NotNull
    private final UserGroupMemberService userGroupMemberService;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ClusterPosition clusterPosition;
    @Nullable
    private String lastChecksum;
    @Nullable
    private Instant lastChecksumDate;
    private Instant cacheCheckUntil;
    @NotNull
    private Status lastStatus;
    @NotNull
    private String lastDetailKey;
    @NotNull
    private String lastDetailValue;

    public UserGroupMembershipChecksumHealthIndicator(@NotNull InternalPeopleService internalPeopleService, @NotNull UserGroupMemberService userGroupMemberService, @NotNull Clock clock, @Value(value="${service.cluster-position}") @NotNull ClusterPosition clusterPosition) {
        Intrinsics.checkNotNullParameter((Object)internalPeopleService, (String)"internalPeopleService");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberService, (String)"userGroupMemberService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        super("User Group Membership Checksum Synchronized Health Check failed");
        this.internalPeopleService = internalPeopleService;
        this.userGroupMemberService = userGroupMemberService;
        this.clock = clock;
        this.clusterPosition = clusterPosition;
        this.cacheCheckUntil = Instant.EPOCH;
        Status status = Status.UNKNOWN;
        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"UNKNOWN");
        this.lastStatus = status;
        this.lastDetailKey = "Not yet run";
        this.lastDetailValue = "User Group Membership Checksum Synchronized Health Check has not been run yet";
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (this.clusterPosition != ClusterPosition.PRIMARY) {
            Status status = Status.UP;
            Intrinsics.checkNotNullExpressionValue((Object)status, (String)"UP");
            this.setStatus(builder, status, "Skipped", "Skip User Group Membership Checksum Synchronized Health Check since not running on primary.", true);
            return;
        }
        if (this.clock.instant().isBefore(this.cacheCheckUntil)) {
            UserGroupMembershipChecksumHealthIndicator.setStatus$default((UserGroupMembershipChecksumHealthIndicator)this, (Health.Builder)builder, (Status)this.lastStatus, (String)this.lastDetailKey, (String)this.lastDetailValue, (boolean)false, (int)16, null);
            return;
        }
        String ownChecksum = this.userGroupMemberService.getUserGroupMembershipChecksum();
        String peopleChecksum = this.internalPeopleService.getUserGroupMembershipChecksum();
        if (((CharSequence)peopleChecksum).length() == 0) {
            Status status = Status.UP;
            Intrinsics.checkNotNullExpressionValue((Object)status, (String)"UP");
            UserGroupMembershipChecksumHealthIndicator.setStatus$default((UserGroupMembershipChecksumHealthIndicator)this, (Health.Builder)builder, (Status)status, (String)"Skipped", (String)"Failed to retrieve checksum from people. Maybe people service is down. Please check people health indicator.", (boolean)false, (int)16, null);
            return;
        }
        if (Intrinsics.areEqual((Object)peopleChecksum, (Object)ownChecksum)) {
            Status status = Status.UP;
            Intrinsics.checkNotNullExpressionValue((Object)status, (String)"UP");
            this.setStatus(builder, status, "Synchronized", "Checksum " + ownChecksum + " matches the checksum in people", true);
        } else {
            Duration duration = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
            if (this.isChecksumUnchangedSince(ownChecksum, (TemporalAmount)duration)) {
                Status status = Status.DOWN;
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"DOWN");
                UserGroupMembershipChecksumHealthIndicator.setStatus$default((UserGroupMembershipChecksumHealthIndicator)this, (Health.Builder)builder, (Status)status, (String)"Not Synchronized", (String)("Checksum " + ownChecksum + " does not match the checksum in people " + peopleChecksum + " and has been synchronized since 5 minutes"), (boolean)false, (int)16, null);
            } else {
                UserGroupMembershipChecksumHealthIndicator.setStatus$default((UserGroupMembershipChecksumHealthIndicator)this, (Health.Builder)builder, (Status)this.lastStatus, (String)"Synchronization in progress", (String)("Checksum " + ownChecksum + " does not match the checksum in people " + peopleChecksum + " but synchronization still in progress"), (boolean)false, (int)16, null);
            }
        }
        this.lastChecksum = ownChecksum;
    }

    private boolean isChecksumUnchangedSince(String checksum, TemporalAmount duration) {
        Instant now = this.clock.instant();
        boolean isUnchangedSinceDuration = this.lastChecksumDate != null && this.lastChecksum != null && Intrinsics.areEqual((Object)checksum, (Object)this.lastChecksum) && now.minus(duration).isAfter(this.lastChecksumDate);
        this.lastChecksumDate = now;
        return isUnchangedSinceDuration;
    }

    private void setStatus(Health.Builder builder, Status status, String detailKey, String detailValue, boolean shouldCache) {
        builder.withDetail(detailKey, (Object)detailValue);
        this.lastDetailKey = detailKey;
        this.lastDetailValue = detailValue;
        builder.status(status);
        this.lastStatus = status;
        if (shouldCache) {
            this.cacheCheckUntil = this.clock.instant().plus(Duration.ofHours(1L));
        }
    }

    static /* synthetic */ void setStatus$default(UserGroupMembershipChecksumHealthIndicator userGroupMembershipChecksumHealthIndicator, Health.Builder builder, Status status, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setStatus");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        userGroupMembershipChecksumHealthIndicator.setStatus(builder, status, string, string2, bl);
    }
}

