/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.notificationservice.mobile.model.MobilePushNotification;
import de.justsoftware.notificationservice.mobile.model.ScheduledMobilePushNotification;
import de.justsoftware.notificationservice.mobile.service.JunoRestClientService;
import de.justsoftware.notificationservice.mobile.service.MobilePushNotificationSendService;
import de.justsoftware.notificationservice.mobile.service.MobilePushTokenService;
import de.justsoftware.notificationservice.mobile.service.ScheduledMobilePushNotificationStore;
import de.justsoftware.notificationservice.mobile.util.JunoUtilKt;
import de.justsoftware.notificationservice.util.TaskSchedulerUtilKt;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002#$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\r\u0010\u0015\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J&\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService;", "", "mobilePushTokenService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;", "mobilePushTokeStore", "Lde/justsoftware/notificationservice/mobile/service/ScheduledMobilePushNotificationStore;", "junoClient", "Lde/justsoftware/notificationservice/mobile/service/JunoRestClientService;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;Lde/justsoftware/notificationservice/mobile/service/ScheduledMobilePushNotificationStore;Lde/justsoftware/notificationservice/mobile/service/JunoRestClientService;Lorg/springframework/scheduling/TaskScheduler;Ljava/time/Clock;)V", "batchSize", "", "sendAll", "", "pushNotifications", "", "Lde/justsoftware/notificationservice/mobile/model/MobilePushNotification;", "process", "process$notification_service", "sendToJuno", "Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService$SendResult;", "scheduledPushNotifications", "Lde/justsoftware/notificationservice/mobile/model/ScheduledMobilePushNotification;", "logJunoClientErrors", "error", "", "scheduledPushes", "durationMs", "", "applySendResult", "result", "SendResult", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushNotificationSendService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushNotificationSendService.kt\nde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,164:1\n1563#2:165\n1634#2,3:166\n1563#2:171\n1634#2,3:172\n1563#2:175\n1634#2,3:176\n1563#2:180\n1634#2,3:181\n3301#2,10:184\n1563#2:194\n1634#2,3:195\n1321#3,2:169\n1#4:179\n8#5:198\n7#5,3:199\n*S KotlinDebug\n*F\n+ 1 MobilePushNotificationSendService.kt\nde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService\n*L\n39#1:165\n39#1:166,3\n57#1:171\n57#1:172,3\n58#1:175\n58#1:176,3\n88#1:180\n88#1:181,3\n92#1:184,10\n95#1:194\n95#1:195,3\n49#1:169,2\n117#1:198\n117#1:199,3\n*E\n"})
public final class MobilePushNotificationSendService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final ScheduledMobilePushNotificationStore mobilePushTokeStore;
    @NotNull
    private final JunoRestClientService junoClient;
    @NotNull
    private final Clock clock;
    private int batchSize;
    private static final Duration PROCESS_RATE = Duration.ofSeconds(5L);
    private static final Duration SCHEDULED_PUSH_TTL = Duration.ofHours(2L);
    private static final int EXPONENTIAL_DELAY_MS = 30000;
    @NotNull
    private static final Logger LOG;

    public MobilePushNotificationSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull ScheduledMobilePushNotificationStore mobilePushTokeStore, @NotNull JunoRestClientService junoClient, @NotNull TaskScheduler taskScheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)mobilePushTokeStore, (String)"mobilePushTokeStore");
        Intrinsics.checkNotNullParameter((Object)junoClient, (String)"junoClient");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.mobilePushTokenService = mobilePushTokenService;
        this.mobilePushTokeStore = mobilePushTokeStore;
        this.junoClient = junoClient;
        this.clock = clock;
        this.batchSize = 50;
        Duration duration = PROCESS_RATE;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"PROCESS_RATE");
        TaskSchedulerUtilKt.scheduleAtFixedRateAndSkipMissed((TaskScheduler)taskScheduler, (Duration)duration, () -> this.process$notification_service());
    }

    /*
     * WARNING - void declaration
     */
    public final void sendAll(@NotNull List<? extends MobilePushNotification> pushNotifications) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(pushNotifications, (String)"pushNotifications");
        Instant now = this.clock.instant();
        Iterable iterable = pushNotifications;
        ScheduledMobilePushNotificationStore scheduledMobilePushNotificationStore = this.mobilePushTokeStore;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushNotification mobilePushNotification = (MobilePushNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)now);
            collection.add(Companion.access$schedule((Companion)Companion, (MobilePushNotification)it, (Instant)now));
        }
        scheduledMobilePushNotificationStore.saveAll((List)destination$iv$iv);
    }

    @VisibleForTesting
    public final void process$notification_service() {
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)this.mobilePushTokeStore.findDue(instant), (int)this.batchSize), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SendResult p0 = (SendResult)element$iv;
            boolean bl = false;
            this.applySendResult(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SendResult sendToJuno(List<ScheduledMobilePushNotification> scheduledPushNotifications) {
        Object object;
        Object p0;
        MobilePushNotification p02;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        long startTimeMs = 0L;
        Object object2 = scheduledPushNotifications;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScheduledMobilePushNotification scheduledMobilePushNotification = (ScheduledMobilePushNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p02.getMobilePushNotification());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p02 = (MobilePushNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JunoUtilKt.toJunoPushNotification((MobilePushNotification)p02));
        }
        object2 = (List)destination$iv$iv;
        Iterable $i$f$map2 = object2;
        boolean bl = false;
        startTimeMs = System.currentTimeMillis();
        Object it = this.junoClient;
        try {
            p0 = object2;
            boolean bl2 = false;
            p0 = Result.constructor-impl((Object)it.sendPushNotifications((List)p0));
        }
        catch (Throwable bl2) {
            p0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        Companion companion2 = companion;
        object2 = p0;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            void e;
            it = throwable;
            p0 = it;
            companion = companion2;
            boolean bl3 = false;
            long durationMs = System.currentTimeMillis() - startTimeMs;
            this.logJunoClientErrors((Throwable)e, scheduledPushNotifications, durationMs);
            companion2 = companion;
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            it = throwable2;
            companion = companion2;
            boolean bl4 = false;
            object = JunoUtilKt.toFailedPushNotificationResults(scheduledPushNotifications, (int)this.batchSize);
            companion2 = companion;
        }
        return Companion.access$toSendResult((Companion)companion2, (PushNotificationResults)((PushNotificationResults)object), scheduledPushNotifications);
    }

    private final void logJunoClientErrors(Throwable error, List<ScheduledMobilePushNotification> scheduledPushes, long durationMs) {
        LOG.error("Error while sending " + scheduledPushes.size() + " push notifications to juno (after " + durationMs + "ms)", error);
    }

    /*
     * WARNING - void declaration
     */
    private final void applySendResult(SendResult result) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ScheduledMobilePushNotification it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        this.mobilePushTokeStore.deleteAll(Companion.access$toIds((Companion)Companion, (List)result.getSuccessfulScheduledPushes()));
        this.mobilePushTokeStore.deleteAll(Companion.access$toIds((Companion)Companion, (List)result.getInvalidScheduledPushes()));
        Iterable iterable = result.getInvalidScheduledPushes();
        MobilePushTokenService mobilePushTokenService = this.mobilePushTokenService;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ScheduledMobilePushNotification scheduledMobilePushNotification = (ScheduledMobilePushNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toTokenId((Companion)Companion, (ScheduledMobilePushNotification)it));
        }
        mobilePushTokenService.deletePushTokens((Collection)((List)destination$iv$iv));
        Iterable $this$partition$iv = result.getFailedScheduledPushes();
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (ScheduledMobilePushNotification)element$iv;
            boolean bl = false;
            boolean bl2 = Companion.access$shouldRetry((Companion)Companion, (ScheduledMobilePushNotification)it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        iterable = new Pair(first$iv, second$iv);
        List failedPushNotificationsToRetry = (List)iterable.component1();
        List failedPushNotificationsToAbandon = (List)iterable.component2();
        this.mobilePushTokeStore.deleteAll(Companion.access$toIds((Companion)Companion, (List)failedPushNotificationsToAbandon));
        first$iv = failedPushNotificationsToRetry;
        mobilePushTokenService = this.mobilePushTokeStore;
        boolean $i$f$map2 = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pushNotification;
            ScheduledMobilePushNotification scheduledMobilePushNotification = (ScheduledMobilePushNotification)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(Companion.access$reschedule((Companion)Companion, (ScheduledMobilePushNotification)pushNotification, (Instant)Companion.access$nextScheduledTime((Companion)Companion, (ScheduledMobilePushNotification)pushNotification)));
        }
        mobilePushTokenService.saveAll((List)destination$iv$iv2);
        this.batchSize = result.getNextBatchSize();
    }

    public static final /* synthetic */ SendResult access$sendToJuno(MobilePushNotificationSendService $this, List scheduledPushNotifications) {
        return $this.sendToJuno(scheduledPushNotifications);
    }

    public static final /* synthetic */ Duration access$getSCHEDULED_PUSH_TTL$cp() {
        return SCHEDULED_PUSH_TTL;
    }

    static {
        Companion $this$logger$iv = Companion;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

