/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.config;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\f"}, d2={"Lde/justsoftware/notificationservice/config/MTLSClientConfiguration;", "", "<init>", "()V", "chatWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "baseUrl", "", "webClientBuilder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "notification-service"})
public class MTLSClientConfiguration {
    @Bean(value={"chatWebClient"})
    @NotNull
    public WebClient chatWebClient(@Value(value="${just.chat.internal.baseUrl}") @NotNull String baseUrl, @NotNull WebClient.Builder webClientBuilder, @NotNull SslBundles sslBundles) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)webClientBuilder, (String)"webClientBuilder");
        Intrinsics.checkNotNullParameter((Object)sslBundles, (String)"sslBundles");
        SslContext sslContext = SslContextBuilder.forClient().keyManager(sslBundles.getBundle("just").getManagers().getKeyManagerFactory()).trustManager(sslBundles.getBundle("just").getManagers().getTrustManagerFactory()).build();
        Intrinsics.checkNotNullExpressionValue((Object)sslContext, (String)"build(...)");
        SslContext sslContext2 = sslContext;
        HttpClient httpClient = HttpClient.create().secure(arg_0 -> MTLSClientConfiguration.chatWebClient$lambda$0(sslContext2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
        HttpClient httpClient2 = httpClient;
        String[] stringArray = new String[]{"application/json"};
        WebClient webClient = webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient2)).baseUrl(baseUrl).defaultHeader("Accept", stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    private static final void chatWebClient$lambda$0(SslContext $sslContext, SslProvider.SslContextSpec ssl) {
        SslProvider.SslContextSpec sslContextSpec = ssl;
        Intrinsics.checkNotNull((Object)sslContextSpec);
        sslContextSpec.sslContext($sslContext);
    }
}

