/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.prosemirror.model.nodes;

import de.justsoftware.wikiservice.prosemirror.model.nodes.InternalLink;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Node;
import de.justsoftware.wikiservice.prosemirror.util.LinkUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J?\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006 "}, d2={"Lde/justsoftware/wikiservice/prosemirror/model/nodes/InternalLink;", "Lde/justsoftware/wikiservice/prosemirror/model/nodes/Node;", "type", "", "title", "id", "headingId", "headingTitle", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "getTitle", "getId", "getHeadingId", "getHeadingTitle", "toDom", "toIcon", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nInternalLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalLink.kt\nde/justsoftware/wikiservice/prosemirror/model/nodes/InternalLink\n+ 2 StringUtils.kt\nde/justsoftware/wikiservice/util/StringUtilsKt\n*L\n1#1,44:1\n3#2,5:45\n3#2,5:50\n*S KotlinDebug\n*F\n+ 1 InternalLink.kt\nde/justsoftware/wikiservice/prosemirror/model/nodes/InternalLink\n*L\n19#1:45,5\n20#1:50,5\n*E\n"})
public final class InternalLink
implements Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final String title;
    @NotNull
    private final String id;
    @Nullable
    private final String headingId;
    @Nullable
    private final String headingTitle;

    public InternalLink(@NotNull String type, @NotNull String title, @NotNull String id, @Nullable String headingId, @Nullable String headingTitle) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.type = type;
        this.title = title;
        this.id = id;
        this.headingId = headingId;
        this.headingTitle = headingTitle;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getHeadingId() {
        return this.headingId;
    }

    @Nullable
    public final String getHeadingTitle() {
        return this.headingTitle;
    }

    @NotNull
    public String toDom() {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        String string3;
        String string4 = this.type;
        String string5 = this.title;
        String string6 = this.id;
        String t$iv = this.headingId;
        boolean $i$f$maybe = false;
        if (t$iv != null) {
            String string7 = t$iv;
            string3 = string6;
            string2 = string5;
            string = string4;
            boolean bl = false;
            object3 = " internal-link-heading-id=\"" + this.headingId + "\"";
            string4 = string;
            string5 = string2;
            string6 = string3;
            object2 = object3;
        } else {
            object2 = "";
        }
        t$iv = this.headingTitle;
        $i$f$maybe = false;
        if (t$iv != null) {
            String it = t$iv;
            object3 = object2;
            string3 = string6;
            string2 = string5;
            string = string4;
            boolean bl = false;
            String string8 = " internal-link-heading-title=\"" + this.headingTitle + "\"";
            string4 = string;
            string5 = string2;
            string6 = string3;
            object2 = object3;
            object = string8;
        } else {
            object = "";
        }
        String string9 = LinkUtilsKt.toInternalWikiHref((String)this.type, (String)this.id, (String)this.headingId);
        String string10 = this.toIcon();
        String string11 = this.headingTitle;
        if (string11 == null) {
            string11 = this.title;
        }
        return "<a type=\"" + string4 + "\" title=\"" + string5 + "\" internal-link-id=\"" + string6 + "\"" + (String)object2 + (String)object + " target=\"_self\" href=\"" + string9 + "\" class=\"prosemirror__internal-link\"><i class=\"" + string10 + "\"></i>" + string11 + "</a>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String toIcon() {
        String string = this.type;
        switch (string.hashCode()) {
            case -14395178: {
                if (string.equals("ARTICLE")) return "fa-light fa-file-alt";
                return "";
            }
            case 1456998445: {
                if (string.equals("CHAPTER")) return "fa-light fa-bookmark";
                return "";
            }
            case 2664368: {
                if (!string.equals("WIKI")) return "";
                return "fa-light fa-book-open";
            }
        }
        return "";
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.title;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @Nullable
    public final String component4() {
        return this.headingId;
    }

    @Nullable
    public final String component5() {
        return this.headingTitle;
    }

    @NotNull
    public final InternalLink copy(@NotNull String type, @NotNull String title, @NotNull String id, @Nullable String headingId, @Nullable String headingTitle) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new InternalLink(type, title, id, headingId, headingTitle);
    }

    public static /* synthetic */ InternalLink copy$default(InternalLink internalLink, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = internalLink.type;
        }
        if ((n & 2) != 0) {
            string2 = internalLink.title;
        }
        if ((n & 4) != 0) {
            string3 = internalLink.id;
        }
        if ((n & 8) != 0) {
            string4 = internalLink.headingId;
        }
        if ((n & 0x10) != 0) {
            string5 = internalLink.headingTitle;
        }
        return internalLink.copy(string, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "InternalLink(type=" + this.type + ", title=" + this.title + ", id=" + this.id + ", headingId=" + this.headingId + ", headingTitle=" + this.headingTitle + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.title.hashCode();
        result = result * 31 + this.id.hashCode();
        result = result * 31 + (this.headingId == null ? 0 : this.headingId.hashCode());
        result = result * 31 + (this.headingTitle == null ? 0 : this.headingTitle.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InternalLink)) {
            return false;
        }
        InternalLink internalLink = (InternalLink)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)internalLink.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.title, (Object)internalLink.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)internalLink.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.headingId, (Object)internalLink.headingId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.headingTitle, (Object)internalLink.headingTitle);
    }
}

