/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.application.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.persistence.DeletionFlagRepository;
import de.justsoftware.wikiservice.persistence.model.DbArticle;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import jakarta.persistence.QueryHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH'J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'J(\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u0003H'J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u001d\u001a\u00020\u0003H\u0017J*\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0 0\u00102\u000e\b\u0001\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J\u0018\u0010#\u001a\u00020\f2\u000e\b\u0001\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H'J\u001c\u0010%\u001a\u00020\u001c2\b\b\u0001\u0010\u0006\u001a\u00020\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u0003H'J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0017J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0017J\u0016\u0010*\u001a\u00020\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0017J\u0016\u0010+\u001a\u00020\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'J0\u0010,\u001a\u00020\u001c2\b\b\u0001\u0010-\u001a\u00020\u00032\b\b\u0001\u0010.\u001a\u00020/2\b\b\u0001\u00100\u001a\u0002012\b\b\u0001\u00102\u001a\u00020\u0003H'J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000304H'J\u001a\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030 04H'J*\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030 0\u00102\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00067\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "Lde/justsoftware/wikiservice/persistence/DeletionFlagRepository;", "Lde/justsoftware/wikiservice/persistence/model/DbArticle;", "Ljava/util/UUID;", "findAllByWikiId", "", "wikiId", "findAllByWikiIdAndDeletionIdIsNull", "findAllBySubscriber", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/application/model/ArticleWithTitleDto;", "subscriberId", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByDeletionIdIsNullAndIdIn", "", "ids", "findByIds", "articleIds", "findByDeletionIdIsNullAndParentIdIn", "parentIds", "findByParentIdIn", "findByParentIds", "", "Lde/justsoftware/wikiservice/model/ParentId;", "findAllByParentIds", "markArticlesByParentIdAsDeleted", "", "deletionId", "deleteAllByParentIds", "countByWikiIdIn", "Lkotlin/Pair;", "wikiIds", "countByWikiIds", "countByParentIds", "chapterIds", "markArticlesByWikiIdAsDeleted", "deleteAllByWikiId", "findAllByDeletionIdIn", "deletionIds", "findAllByDeletionIds", "deleteAllByDeletionIds", "deleteAllByDeletionIdIn", "updateParentIdAndPosition", "parentId", "parentType", "Lde/justsoftware/wikiservice/model/IdType;", "relativePosition", "", "id", "streamAllIds", "Ljava/util/stream/Stream;", "streamAllIdsAndTenants", "findWikiIdForArticles", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleRepository.kt\nde/justsoftware/wikiservice/persistence/ArticleRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,231:1\n1368#2:232\n1454#2,5:233\n1368#2:238\n1454#2,5:239\n1485#2:244\n1510#2,3:245\n1513#2,3:255\n1368#2:258\n1454#2,5:259\n1485#2:264\n1510#2,3:265\n1513#2,3:275\n1557#2:278\n1628#2,3:279\n1557#2:282\n1628#2,3:283\n1368#2:286\n1454#2,5:287\n1368#2:292\n1454#2,5:293\n1863#2,2:298\n381#3,7:248\n381#3,7:268\n*S KotlinDebug\n*F\n+ 1 ArticleRepository.kt\nde/justsoftware/wikiservice/persistence/ArticleRepository\n*L\n58#1:232\n58#1:233,5\n73#1:238\n73#1:239,5\n74#1:244\n74#1:245,3\n74#1:255,3\n83#1:258\n83#1:259,5\n84#1:264\n84#1:265,3\n84#1:275,3\n111#1:278\n111#1:279,3\n114#1:282\n114#1:283,3\n135#1:286\n135#1:287,5\n176#1:292\n176#1:293,5\n184#1:298,2\n74#1:248,7\n84#1:268,7\n*E\n"})
public interface ArticleRepository
extends DeletionFlagRepository<DbArticle, UUID> {
    @NotNull
    public Set<DbArticle> findAllByWikiId(@NotNull UUID var1);

    @NotNull
    public Set<DbArticle> findAllByWikiIdAndDeletionIdIsNull(@NotNull UUID var1);

    @Query(value="SELECT new de.justsoftware.wikiservice.application.model.ArticleWithTitleDto(a.id, a.wikiId, a.parentId, a.parentType, av.title) FROM DbArticle a INNER JOIN DbSubscription s ON (a.id = s.itemId AND s.itemType = 'WIKI_ARTICLE') INNER JOIN DbArticleVersion av ON (a.id = av.articleId) WHERE av.createdAt IN  (SELECT max(al.createdAt) FROM DbArticleVersion al WHERE al.articleId = av.articleId) AND s.isSubscribed = true AND s.subscriber = :subscriber AND a.deletionId is null")
    @NotNull
    public Page<ArticleWithTitleDto> findAllBySubscriber(@Param(value="subscriber") long var1, @NotNull Pageable var3);

    @Deprecated(message="Do not use this function directly. Use {@link #findByIds(Set)} instead.")
    @NotNull
    public List<DbArticle> findByDeletionIdIsNullAndIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<DbArticle> findByIds(@NotNull Set<UUID> articleIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)articleIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$findByIds$stub_for_inlining = false;
            boolean bl = false;
            Iterable list$iv$iv = this.findByDeletionIdIsNullAndIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use {@link #findByParentIds(Set)} instead.")
    @NotNull
    public List<DbArticle> findByDeletionIdIsNullAndParentIdIn(@NotNull List<UUID> var1);

    @Deprecated(message="Use {@link #findAllByParentIds(Set)} instead.")
    @NotNull
    public List<DbArticle> findByParentIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<ParentId, List<DbArticle>> findByParentIds(@NotNull Set<UUID> parentIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$findByParentIds$stub_for_inlining$0 = false;
            boolean bl = false;
            list$iv$iv = this.findByDeletionIdIsNullAndParentIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DbArticle it = (DbArticle)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<ParentId, List<DbArticle>> findAllByParentIds(@NotNull Set<UUID> parentIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$findAllByParentIds$stub_for_inlining$2 = false;
            boolean bl = false;
            list$iv$iv = this.findByParentIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DbArticle it = (DbArticle)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByParentIds(Set, DeletionId)} instead.")
    @Modifying
    @Query(value="\n            UPDATE DbArticle a\n            SET a.deletionId = :deletionId\n            WHERE a.deletionId is null\n            AND a.parentId IN :parentIds\n        ")
    public void markArticlesByParentIdAsDeleted(@Param(value="parentIds") @NotNull List<UUID> var1, @Param(value="deletionId") @NotNull UUID var2);

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    default public Set<UUID> deleteAllByParentIds(@NotNull Set<UUID> parentIds, @NotNull UUID deletionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable $this$map$iv2 = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.markArticlesByParentIdAsDeleted((List)it, deletionId);
            collection.add(Unit.INSTANCE);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = this.findAllByDeletionIds(SetsKt.setOf((Object)deletionId));
        boolean $i$f$map2 = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DbArticle dbArticle = (DbArticle)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it2.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    @Deprecated(message="Do not use this function directly. Use {@link #countByWikiIds(Set)} instead.")
    @Query(value="\n       SELECT new kotlin.Pair(a.wikiId, count(a))\n       FROM DbArticle a\n       WHERE a.wikiId in :wikiIds\n       AND a.deletionId is null\n       GROUP BY a.wikiId\n    ")
    @NotNull
    public List<Pair<UUID, Long>> countByWikiIdIn(@Param(value="wikiIds") @NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<UUID, Long> countByWikiIds(@NotNull Set<UUID> wikiIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)wikiIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$countByWikiIds$stub_for_inlining$7 = false;
            boolean bl = false;
            Iterable list$iv$iv = this.countByWikiIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Query(value="SELECT COUNT(*) FROM DbArticle a WHERE a.parentId IN :chapterIds AND a.deletionId is null")
    public long countByParentIds(@Param(value="chapterIds") @NotNull Set<UUID> var1);

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByWikiId(WikiId, DeletionId)} instead.")
    @Modifying
    @Query(value="\n            UPDATE DbArticle a\n            SET a.deletionId = :deletionId\n            WHERE a.deletionId is null\n            AND a.wikiId = :wikiId\n        ")
    public void markArticlesByWikiIdAsDeleted(@Param(value="wikiId") @NotNull UUID var1, @Param(value="deletionId") @NotNull UUID var2);

    @Transactional
    @NotNull
    default public Set<DbArticle> deleteAllByWikiId(@NotNull UUID wikiId, @NotNull UUID deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        this.markArticlesByWikiIdAsDeleted(wikiId, deletionId);
        Unit $this$deleteAllByWikiId_u24lambda_u248 = Unit.INSTANCE;
        boolean bl = false;
        return this.findAllByDeletionIds(SetsKt.setOf((Object)deletionId));
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    @NotNull
    public Set<DbArticle> findAllByDeletionIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    default public Set<DbArticle> findAllByDeletionIds(@NotNull Set<UUID> deletionIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findAllByDeletionIdIn(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Transactional
    default public void deleteAllByDeletionIds(@NotNull Set<UUID> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByDeletionIdIn(it);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    public void deleteAllByDeletionIdIn(@NotNull List<UUID> var1);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE DbArticle a\n            SET a.parentId = :parentId,\n                a.parentType = :parentType,\n                a.relativePosition = :relativePosition\n            WHERE a.id = :id\n        ")
    public void updateParentIdAndPosition(@Param(value="parentId") @NotNull UUID var1, @Param(value="parentType") @NotNull IdType var2, @Param(value="relativePosition") int var3, @Param(value="id") @NotNull UUID var4);

    @Query(value="SELECT a.id FROM DbArticle a")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize")})
    @NotNull
    public Stream<UUID> streamAllIds();

    @Query(value="SELECT a.id, w.tenantId FROM DbArticle a JOIN DbWiki w on a.wikiId = w.id")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize"), @QueryHint(value="false", name="org.hibernate.cacheable"), @QueryHint(value="true", name="org.hibernate.readOnly")})
    @NotNull
    public Stream<Pair<UUID, UUID>> streamAllIdsAndTenants();

    @Query(value="\n        SELECT new kotlin.Pair(a.id, a.wikiId) FROM DbArticle a WHERE a.id IN :articleIds\n        ")
    @NotNull
    public List<Pair<UUID, UUID>> findWikiIdForArticles(@Param(value="articleIds") @NotNull List<UUID> var1);
}

