/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business;

import de.justsoftware.onx.monitoring.business.ToroHealthIndicator;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component(value="update-processes")
@ParametersAreNonnullByDefault
public class UpdateProcessesHealthIndicator
extends ToroHealthIndicator {
    public static final String NAME = "update-processes";
    private final JucoServerVersionService _jucoServerVersionService;

    @Autowired
    public UpdateProcessesHealthIndicator(JucoServerVersionService jucoServerVersionService) {
        this._jucoServerVersionService = jucoServerVersionService;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            boolean ok = this._jucoServerVersionService.getAllUpdateProcessesFinished();
            if (ok) {
                builder.up();
            } else {
                this.handleError(builder, NAME, "Heartbeat update processes failed");
            }
        }
        catch (Exception e) {
            this.handleError(builder, NAME, "Heartbeat update processes failed", (Throwable)e);
        }
    }
}

