/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.business.LanguageService;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.server.util.CookieUtil;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.common.shared.util.StringUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Lazy(value=false)
@Primary
public class JucoLocaleResolver
implements HandlerInterceptor,
LocaleResolver {
    private static final String PERSISTED_LOCALE_COOKIE = "jc_locale";
    private static final String PERSISTED_LOCALE_ATTRIBUTE = "jc_request_locale";
    private final Settings _settings;
    private final LanguageService _languageService;
    private final AcceptHeaderLocaleResolver _delegateResolver;

    @Autowired
    public JucoLocaleResolver(Settings settings, LanguageService languageService) {
        this._settings = settings;
        this._languageService = languageService;
        this._delegateResolver = new AcceptHeaderLocaleResolver();
        List supportedLocales = this._languageService.getAvailableLanguageCode().stream().map(Locale::new).collect(Collectors.toList());
        this._delegateResolver.setSupportedLocales(supportedLocales);
        this._delegateResolver.setDefaultLocale(JucoLocaleResolver.toLocale((String)this._settings.defaultLanguage()));
    }

    private static @Nullable Locale getCachedLocale() {
        Object attribute;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (attribute = requestAttributes.getAttribute("jc_request_locale", 0)) instanceof Locale) {
            return (Locale)attribute;
        }
        return null;
    }

    private static void setAsCachedLocale(Locale locale) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute("jc_request_locale", (Object)locale, 0);
        }
    }

    private static Locale toLocale(String languageId) {
        return new Locale(languageId);
    }

    private Locale getRequestLocale(HttpServletRequest request) {
        String requestedLocale;
        ImmutableSet availableLanguageCodes = this._languageService.getAvailableLanguageCode();
        if (availableLanguageCodes.contains(requestedLocale = request.getParameter("locale"))) {
            return JucoLocaleResolver.toLocale((String)requestedLocale);
        }
        String cookieValue = this.getCookieValue(request);
        if (cookieValue != null && availableLanguageCodes.contains(cookieValue)) {
            return JucoLocaleResolver.toLocale((String)cookieValue);
        }
        return this._delegateResolver.resolveLocale(request);
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale cachedLocale = JucoLocaleResolver.getCachedLocale();
        if (cachedLocale != null) {
            return cachedLocale;
        }
        Locale resolvedLocale = this.getRequestLocale(request);
        JucoLocaleResolver.setAsCachedLocale((Locale)resolvedLocale);
        return resolvedLocale;
    }

    public void setLocale(@NonNull HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable Locale locale) {
        String languageId = locale != null ? locale.getLanguage() : null;
        Locale newLocale = this._languageService.getAvailableLanguageCode().contains((Object)languageId) ? Objects.requireNonNull(locale) : this.getDefaultLocale();
        JucoLocaleResolver.setAsCachedLocale((Locale)newLocale);
        this.setCookieValue(request, response, newLocale);
    }

    private Locale getDefaultLocale() {
        return JucoLocaleResolver.toLocale((String)this._settings.defaultLanguage());
    }

    private @Nullable String getCookieValue(HttpServletRequest request) {
        return CookieUtil.getCookieValueOrNull((String)"jc_locale", (HttpServletRequest)request);
    }

    private void setCookieValue(HttpServletRequest request, @Nullable HttpServletResponse response, Locale locale) {
        CookieUtil.addCookie((String)"jc_locale", (String)locale.getLanguage(), (int)Numbers.longToInt((long)TimeUnit.DAYS.toSeconds(356L)), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        String cookieValue = this.getCookieValue(request);
        if (StringUtil.isBlank((String)cookieValue)) {
            this.setCookieValue(request, response, this.resolveLocale(request));
        }
        return true;
    }
}

