/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.presentation.server;

import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.server.model.LoginPage;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class NewMailController {
    private final PersonService _personService;

    @Autowired
    @ParametersAreNonnullByDefault
    public NewMailController(PersonService personService) {
        this._personService = personService;
    }

    @RequestMapping(value={"/newMail/{code}"}, produces={"text/html"})
    public void activateNewMail(@Nonnull @PathVariable(value="code") String code, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        boolean success = this._personService.activateNewMail(code);
        LoginPage page = success ? LoginPage.NEW_MAIL : LoginPage.NEW_MAIL_FAILURE;
        response.sendRedirect(page.getUrl());
    }
}

