/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server.resource;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.server.resource.HtmlScaffoldServlet;
import com.freiheit.toro.server.resource.StartConfiguration;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import de.justsoftware.context.api.business.JustContextService;
import de.justsoftware.context.api.model.JustContext;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.presentation.shared.config.StartConfigurationField;
import de.justsoftware.onx.common.presentation.shared.config.StringStartConfigurationField;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.StaticWebResource;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.design.shared.model.ThemeWebResource;
import de.justsoftware.onx.design.shared.model.WebResource;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.tracking.TrackingService;
import de.justsoftware.onx.tracking.model.TrackingSettings;
import de.justsoftware.web.design.WebResourceHandler;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.gwtwidgets.server.spring.ServletUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@Service(value="htmlScaffoldServlet")
public class HtmlScaffoldServlet
implements Controller {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlScaffoldServlet.class);
    private static final String SERVLET_PATH = "html";
    private static final String CUSTOMER_JAVASCRIPT_FILE = "custom.js";
    private final Settings _settings;
    private final String _version;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private ServerUrlUtil _serverUrlUtil;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private PersonService _personService;
    @Autowired
    private FrontendLoginService _loginService;
    @Autowired
    private WebResourceHandler _webResourceHandler;
    @Autowired
    private ThemeService _themeService;
    @Autowired
    private TrackingService _trackingService;
    @Autowired
    private LocaleResolver _localeResolver;
    @Value(value="${just.client.libs.path}")
    private String _justClientLibsPath;
    @Value(value="${just-context.libs.url}")
    private String _justContextLib;
    @Value(value="${just-notification.libs.url:/notification/bundles/notification.bundle.js}")
    private String _justNotificationLib;
    @Value(value="${just-people.app.url:/people/bundles/people.bundle.js}")
    private String _peopleAppUrl;
    @Value(value="${just-search.app.url:/search/bundles/search.bundle.js}")
    private String _searchAppUrl;
    @Value(value="${just-news.app.url:/news/bundles/news.bundle.js}")
    private String _newsAppUrl;
    @Value(value="${just-wiki.app.url:/wiki/bundles/wiki.bundle.js}")
    private String _wikiAppUrl;
    @Value(value="${just-chat.app.url:/chat/bundles/chat.bundle.js}")
    private String _chatAppUrl;
    @Value(value="${just-admin.app.url:/admin/bundles/admin.bundle.js}")
    private String _adminAppUrl;
    @Value(value="${just-ai.app.url:/ai/bundles/ai.bundle.js}")
    private String _aiAppUrl;
    @Autowired
    private JustContextService _justContextService;
    @Autowired
    private JucoObjectMapper _jucoObjectMapper;
    @Autowired
    private AppConfigService _appConfigService;
    private final boolean _collectRequests;
    private final boolean _profileRequests;

    @Autowired
    public HtmlScaffoldServlet(Settings settings, @Value(value="${justconnect.version}") String version, @Value(value="${collectRequests:true}") boolean collectRequests, @Value(value="${profileRequests:false}") boolean profileRequests) {
        this._settings = settings;
        this._version = version;
        this._collectRequests = collectRequests;
        this._profileRequests = profileRequests;
    }

    private String loadCustomerJavaScript() {
        try {
            URL url;
            try {
                url = Resources.getResource((String)CUSTOMER_JAVASCRIPT_FILE);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Cold not load customer specific JavaScript", (Throwable)e);
            return "";
        }
    }

    public @Nullable ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, TemplateException, JSONException {
        ServletUtils.setResponse((HttpServletResponse)response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("logout"))) {
            this._loginService.logout(request, response);
            return this.redirect(request, response);
        }
        Optional<DBPerson> currentUser = Optional.ofNullable(SecurityUtils.getUserIdOrNull()).map(userId -> this._personService.getPersonById(userId));
        if (currentUser.map(DBPerson::getLanguageId).isPresent()) {
            this._localeResolver.setLocale(request, response, StringUtils.parseLocaleString((String)currentUser.get().getLanguageId()));
        }
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser(request, response);
        PersonId userId2 = authCtx.getUserId();
        String locale = authCtx.getLocale();
        BasicConstants basicConst = (BasicConstants)this._i18nService.createProxy(BasicConstants.class, locale);
        Theme defaultTheme = this._themeService.getDefaultTheme();
        HashMap model = Maps.newHashMap();
        if (this._settings.isTermsAcceptanceRequired()) {
            DBPerson user;
            String loginCode = request.getParameter("acceptTerms");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)loginCode)) {
                try {
                    this._personService.acceptTerms(userId2, loginCode);
                    return this.redirect(request, response);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if ((user = this._personService.getPersonById(userId2)) != null && !Boolean.TRUE.equals(user.getTermsAccepted())) {
                response.sendRedirect("/account/acceptTerms/" + this._personService.generateLoginCode(userId2));
                return null;
            }
        }
        BasicMessages basicMsg = (BasicMessages)this._i18nService.createProxy(BasicMessages.class, locale);
        StartConfiguration startConfig = new StartConfiguration();
        model.put("startConfig", startConfig);
        model.put("loadingApplicationXPleaseWait", basicMsg.loadingApplicationXPleaseWait(this._settings.getDefaultSiteTitle()));
        model.put("htmlLoadingTextHint", basicConst.htmlLoadingTextHint());
        model.put("staticResourcePrefix", this._serverUrlUtil.getStaticResourcePrefix());
        model.put("dynamicResourcePrefix", this._serverUrlUtil.getDynamicResourcePrefix());
        model.put("defaultTitle", this._settings.getDefaultSiteTitle());
        model.put("locale", locale);
        model.put("hide", basicConst.hide());
        model.put("nocacheSuffix", "");
        startConfig.set((StartConfigurationField)StringStartConfigurationField.PLATFORM_VERSION, (Object)this._version);
        model.put("collectRequests", this._collectRequests);
        model.put("profileRequests", this._profileRequests);
        model.put("favIconUrl", this._settings.getFavIconUrl());
        model.put("favIconImageType", this._settings.getFavIconImageType());
        ThemeWebResource defaultThemeResource = ThemeWebResource.of((ThemeId)defaultTheme.getId());
        ImmutableSet.Builder cssResources = ImmutableSet.builder();
        cssResources.add((Object[])new WebResource[]{StaticWebResource.JUCO_MAIN_CSS, defaultThemeResource});
        HashMap cssResourceMap = this._webResourceHandler.getCurrentResourceNames((Iterable)cssResources.build(), request, response);
        String mainCss = (String)cssResourceMap.get(StaticWebResource.JUCO_MAIN_CSS);
        model.put("jucoDesignResource", mainCss);
        model.put("defaultThemeResource", defaultThemeResource);
        model.put("defaultThemeResourceUri", cssResourceMap.get(defaultThemeResource));
        ImmutableSet.Builder cssFiles = ImmutableSet.builder().add((Object)(this._justClientLibsPath + "just-client-libs.bundle.css"));
        model.put("cssFiles", cssFiles.build());
        JustContext justContext = this._justContextService.getContext(authCtx);
        model.put("justContext", this._jucoObjectMapper.writeValueAsString((Object)justContext));
        ImmutableSet scriptFiles = this.getScriptFiles(authCtx);
        model.put("scriptFiles", scriptFiles);
        model.put("contextPath", request.getContextPath());
        model.put("customerJavaScript", this.loadCustomerJavaScript());
        TrackingSettings trackingSettings = this._trackingService.getTrackingSettings(authCtx);
        model.put("matomoURL", Objects.requireNonNullElse(trackingSettings.getMatomoUrl(), ""));
        model.put("matomoSiteId", Objects.requireNonNullElse(trackingSettings.getMatomoSiteId(), ""));
        model.put("cookieBannerEnabled", trackingSettings.isCookieBannerEnabled());
        this.putEnabledFeatureToggles((Map)model);
        return this.renderJust(response, (Map)model);
    }

    private ImmutableSet<String> getScriptFiles(AuthorizationContext authCtx) {
        ImmutableSet.Builder scriptBuilder = ImmutableSet.builder();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this._justContextLib)) {
            scriptBuilder.add((Object)this._justContextLib);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this._justNotificationLib)) {
            scriptBuilder.add((Object)this._justNotificationLib);
        }
        scriptBuilder.add((Object)"/superdrive/bundles/superdrive.bundle.js");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this._peopleAppUrl)) {
            scriptBuilder.add((Object)this._peopleAppUrl);
        }
        scriptBuilder.add((Object)this._searchAppUrl);
        if (this._settings.isAiAppEnabled()) {
            scriptBuilder.add((Object)this._aiAppUrl);
        }
        this._appConfigService.getAvailableCoreAppsConfigs((AuthorizationCheckContextWithUserId)authCtx).forEach(app -> {
            switch (1.$SwitchMap$de$justsoftware$onx$appswitcher$shared$model$CoreApp[app.getApp().ordinal()]) {
                case 1: {
                    scriptBuilder.add((Object)this._chatAppUrl);
                    break;
                }
                case 2: {
                    scriptBuilder.add((Object)this._newsAppUrl);
                    break;
                }
                case 3: {
                    scriptBuilder.add((Object)this._wikiAppUrl);
                    break;
                }
                case 4: {
                    scriptBuilder.add((Object)this._adminAppUrl);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(app) + " is unknown");
                }
            }
        });
        return scriptBuilder.build();
    }

    private @Nullable ModelAndView redirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = request.getParameter("token");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)token)) {
            response.sendRedirect("html#" + URLEncoder.encode(token, Charsets.UTF_8));
        } else {
            response.sendRedirect(this._serverUrlUtil.getSystemDomainPrefix());
        }
        return null;
    }

    private ModelAndView renderJust(HttpServletResponse response, Map<String, ?> model) {
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "max-age=0, no-store");
        response.setHeader("Vary", "User-Agent");
        return new ModelAndView("just", model);
    }

    private void putEnabledFeatureToggles(Map<String, Object> model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap featureToggle = builder.build();
        if (!featureToggle.isEmpty()) {
            model.put("featureToggleJson", new JSONObject((Map)featureToggle).toString());
        }
    }
}

