/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.controller;

import de.justsoftware.publicAPI.authorization.ProfileAuthContext;
import de.justsoftware.publicAPI.controller.WikiController;
import de.justsoftware.publicAPI.controller.model.ArticleExportDto;
import de.justsoftware.publicAPI.exception.MissingScopeException;
import de.justsoftware.publicAPI.generated.wiki.apis.ExportControllerApi;
import de.justsoftware.publicAPI.model.ArticleId;
import de.justsoftware.publicAPI.model.WikiId;
import de.justsoftware.publicAPI.util.CollectionUtilsKt;
import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResult;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.shared.model.TenantId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/wiki"})
@Tag(name="Just Wiki", description="Public API for Just Wiki contents")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JZ\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0001\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t2\u0010\b\u0001\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\t2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/publicAPI/controller/WikiController;", "", "searchServiceInternalConnector", "Lde/justsoftware/search/shared/SearchServiceInternalConnector;", "exportControllerApi", "Lde/justsoftware/publicAPI/generated/wiki/apis/ExportControllerApi;", "<init>", "(Lde/justsoftware/search/shared/SearchServiceInternalConnector;Lde/justsoftware/publicAPI/generated/wiki/apis/ExportControllerApi;)V", "exportArticles", "", "Lde/justsoftware/publicAPI/controller/model/ArticleExportDto;", "modifiedAfter", "Ljava/time/Instant;", "wikiIds", "Lde/justsoftware/publicAPI/model/WikiId;", "articleIds", "Lde/justsoftware/publicAPI/model/ArticleId;", "offset", "", "limit", "authContext", "Lde/justsoftware/publicAPI/authorization/ProfileAuthContext;", "Companion", "public-api-service"})
@SourceDebugExtension(value={"SMAP\nWikiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiController.kt\nde/justsoftware/publicAPI/controller/WikiController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CollectionUtils.kt\nde/justsoftware/publicAPI/util/CollectionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,139:1\n1#2:140\n1#2:173\n7#3:141\n7#3:145\n1628#4,3:142\n1628#4,3:146\n1557#4:149\n1628#4,3:150\n1557#4:153\n1628#4,3:154\n1246#4,4:159\n1611#4,9:163\n1863#4:172\n1864#4:174\n1620#4:175\n477#5:157\n423#5:158\n*S KotlinDebug\n*F\n+ 1 WikiController.kt\nde/justsoftware/publicAPI/controller/WikiController\n*L\n117#1:173\n105#1:141\n106#1:145\n105#1:142,3\n106#1:146,3\n114#1:149\n114#1:150,3\n116#1:153\n116#1:154,3\n116#1:159,4\n117#1:163,9\n117#1:172\n117#1:174\n117#1:175\n116#1:157\n116#1:158\n*E\n"})
public class WikiController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchServiceInternalConnector searchServiceInternalConnector;
    @NotNull
    private final ExportControllerApi exportControllerApi;
    public static final long MAX_EXPORT_LIMIT = 1000L;
    @NotNull
    public static final String USER_WIKI_READ_PERMISSION = "user:wiki.read";

    public WikiController(@NotNull SearchServiceInternalConnector searchServiceInternalConnector, @Qualifier(value="commonRequestExportControllerApi") @NotNull ExportControllerApi exportControllerApi) {
        Intrinsics.checkNotNullParameter((Object)searchServiceInternalConnector, (String)"searchServiceInternalConnector");
        Intrinsics.checkNotNullParameter((Object)exportControllerApi, (String)"exportControllerApi");
        this.searchServiceInternalConnector = searchServiceInternalConnector;
        this.exportControllerApi = exportControllerApi;
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Returns a list of all published Wiki articles visible for the current user. Draft versions are omitted.", description="This route uses the permissions of the caller and is thus currently only available with the **OAuth 2.0 Password Flow** and **OAuth 2.0 Authorization Code Flow**\n\n**Needed Scopes:** user:wiki.read")
    @ApiResponses(value={@ApiResponse(description="Successfully exported Wiki articles", responseCode="200"), @ApiResponse(description="Request validation error: one or more inputs are invalid", responseCode="400")})
    @GetMapping(value={"articles"})
    @NotNull
    public List<ArticleExportDto> exportArticles(@Parameter(name="modifiedAfter", description="Return Wiki articles modified after the given UTC datetime.", required=false, example="2018-02-26T02:00:00.000Z") @RequestParam(value="modifiedAfter", required=false) @Nullable Instant modifiedAfter, @Parameter(name="wikiIds", description="Return content only for the specified Wikis", required=false) @RequestParam(value="wikiIds", required=false) @Nullable List<WikiId> wikiIds, @Parameter(name="articleIds", description="Return content only for the specified Articles", required=false) @RequestParam(value="articleIds", required=false) @Nullable List<ArticleId> articleIds, @Parameter(name="offset", description="Skip first n (offset) Wiki articles to export.", required=false) @Min(value=0L, message="Offset must be a non-negative integer") @RequestParam(value="offset", required=false, defaultValue="0") int offset, @Parameter(name="limit", description="Max number of simultaneously exported articles.", required=false) @Min(value=1L, message="Limit must be a positive integer less or equal to 1000") @Max(value=1000L, message="Limit must be a positive integer less or equal to 1000") @RequestParam(value="limit", required=false, defaultValue="50") int limit, @NotNull ProfileAuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.hasScope(USER_WIKI_READ_PERMISSION)) {
            throw new MissingScopeException();
        }
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapKeysTo$iv$iv;
            Map $this$mapTo$iv$iv;
            void $this$map$iv;
            Object item$iv$iv4;
            void $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            SearchResult $this$mapToSet$iv;
            Collection collection;
            void $this$mapTo$iv$iv4;
            Set $this$mapToSet$iv2;
            Date date;
            SortDirection p0;
            Object object;
            SearchServiceInternalConnector searchServiceInternalConnector = this.searchServiceInternalConnector;
            ProfileId profileId = new ProfileId(((Number)authContext.getUser().getId()).longValue());
            TenantId tenantId = new TenantId((UUID)authContext.getTenantId().getId());
            Instant instant = modifiedAfter;
            if (instant != null) {
                Instant instant2 = instant;
                object = searchServiceInternalConnector;
                boolean $i$f$exportArticles$stub_for_inlining = false;
                boolean bl = false;
                date = Date.from((Instant)p0);
                searchServiceInternalConnector = object;
            } else {
                date = null;
            }
            Date date2 = date;
            Iterable iterable = SetsKt.setOf((Object)SearchType.WIKI_ARTICLE);
            p0 = SortDirection.DESC;
            SortBy $i$f$exportArticles$stub_for_inlining = SortBy.MODIFY_DATE;
            List<WikiId> list = wikiIds;
            Iterable iterable2 = list != null ? (Collection)list : (Collection)SetsKt.emptySet();
            object = searchServiceInternalConnector;
            boolean $i$f$mapToSet22 = false;
            void var17_30 = $this$mapToSet$iv2;
            Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                void it;
                WikiId wikiId = (WikiId)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(SearchableId.Companion.fromCanonicalId(it.toString()));
            }
            Set bl = (Set)destination$iv$iv;
            List<ArticleId> list2 = articleIds;
            Iterable $i$f$mapToSet22 = list2 != null ? (Collection)list2 : (Collection)SetsKt.emptySet();
            boolean $i$f$mapToSet = false;
            destination$iv$iv = $this$mapToSet$iv;
            Object destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void it2;
                ArticleId bl2 = (ArticleId)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(SearchableId.Companion.fromCanonicalId(it2.toString()));
            }
            $this$mapToSet$iv2 = (Set)destination$iv$iv2;
            List searchResult = object.search(new SearchParam(tenantId, profileId, null, iterable, null, null, null, null, $this$mapToSet$iv2, null, bl, null, null, null, date2, null, true, offset, limit, $i$f$exportArticles$stub_for_inlining, p0, 47860, null)).getResults();
            if (searchResult.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv2 = searchResult;
            boolean $i$f$map22 = false;
            iterable = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
                void it;
                $this$mapToSet$iv = (SearchResult)item$iv$iv4;
                object = destination$iv$iv3;
                boolean bl4 = false;
                object.add(new ArticleId(it.getId().toCanonicalId()));
            }
            List articleIds2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
            Iterable $i$f$map22 = articleIds2;
            object = this.exportControllerApi;
            boolean $i$f$map = false;
            destination$iv$iv3 = $this$map$iv;
            Object destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            item$iv$iv4 = $this$mapTo$iv$iv.iterator();
            while (item$iv$iv4.hasNext()) {
                void it;
                Object item$iv$iv5 = item$iv$iv4.next();
                ArticleId bl4 = (ArticleId)item$iv$iv5;
                collection = destination$iv$iv4;
                boolean bl5 = false;
                collection.add(it.toString());
            }
            Map $this$mapKeys$iv = object.exportProsemirror((List)destination$iv$iv4);
            boolean $i$f$mapKeys = false;
            $this$mapTo$iv$iv = $this$mapKeys$iv;
            destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Object it;
                Object item$iv$iv3;
                Object item$iv$iv2;
                destination$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv4;
                boolean bl6 = false;
                item$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                item$iv$iv3 = new ArticleId((String)it.getKey());
                Object it2 = object;
                boolean bl7 = false;
                it = it$iv$iv.getValue();
                it2.put(item$iv$iv3, it);
            }
            Object articleHTMLContent = destination$iv$iv4;
            Iterable $this$mapNotNull$iv = searchResult;
            boolean $i$f$mapNotNull = false;
            $this$mapKeysTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ArticleExportDto it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl8 = false;
                SearchResult it = (SearchResult)element$iv$iv;
                boolean bl9 = false;
                ArticleId articleId = new ArticleId(it.getId().toCanonicalId());
                String htmlContent = (String)articleHTMLContent.get(articleId);
                if ((htmlContent != null ? ArticleExportDto.Companion.fromSearchResult(it, htmlContent) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl10 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            return (List)destination$iv$iv4;
        }
        catch (RuntimeException e) {
            if (!(!(e.getCause() instanceof DataBufferLimitException))) {
                boolean bl = false;
                String string = "Too much data loaded. Reduce the limit to avoid this error. Current limit was: " + limit + ".";
                throw new IllegalArgumentException(string.toString());
            }
            throw e;
        }
    }
}

