/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.controller;

import de.justsoftware.publicAPI.authorization.ProfileAuthContext;
import de.justsoftware.publicAPI.controller.DriveController;
import de.justsoftware.publicAPI.controller.model.DocumentExportDto;
import de.justsoftware.publicAPI.exception.MissingScopeException;
import de.justsoftware.publicAPI.model.DocumentId;
import de.justsoftware.publicAPI.util.CollectionUtilsKt;
import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchDriveFileType;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResult;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.shared.model.TenantId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClient;

@RestController
@RequestMapping(value={"/v1/drive"})
@Tag(name="Just Drive", description="Public API for Just Drive contents")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJl\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0010\b\u0001\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00112\u0010\b\u0001\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00112\u0010\b\u0001\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00112\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\"\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006%"}, d2={"Lde/justsoftware/publicAPI/controller/DriveController;", "", "searchServiceInternalConnector", "Lde/justsoftware/search/shared/SearchServiceInternalConnector;", "driveBaseUrl", "", "commonRequestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Lde/justsoftware/search/shared/SearchServiceInternalConnector;Ljava/lang/String;Lorg/springframework/http/client/ClientHttpRequestInitializer;Lorg/springframework/web/client/RestClient$Builder;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "kotlin.jvm.PlatformType", "Lorg/springframework/web/client/RestClient;", "exportArticles", "", "Lde/justsoftware/publicAPI/controller/model/DocumentExportDto;", "modifiedAfter", "Ljava/time/Instant;", "documentIds", "Lde/justsoftware/publicAPI/model/DocumentId;", "shareIds", "filetypes", "Lde/justsoftware/search/shared/model/SearchDriveFileType;", "offset", "", "limit", "authContext", "Lde/justsoftware/publicAPI/authorization/ProfileAuthContext;", "download", "", "documentId", "response", "Ljakarta/servlet/http/HttpServletResponse;", "Companion", "public-api-service"})
@SourceDebugExtension(value={"SMAP\nDriveController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveController.kt\nde/justsoftware/publicAPI/controller/DriveController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/publicAPI/util/CollectionUtilsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,202:1\n1#2:203\n1557#3:204\n1628#3,3:205\n1628#3,3:209\n1628#3,3:213\n1557#3:216\n1628#3,3:217\n1863#3,2:221\n7#4:208\n7#4:212\n216#5:220\n217#5:223\n*S KotlinDebug\n*F\n+ 1 DriveController.kt\nde/justsoftware/publicAPI/controller/DriveController\n*L\n121#1:204\n121#1:205,3\n131#1:209,3\n132#1:213,3\n140#1:216\n140#1:217,3\n187#1:221,2\n131#1:208\n132#1:212\n186#1:220\n186#1:223\n*E\n"})
public class DriveController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchServiceInternalConnector searchServiceInternalConnector;
    private final RestClient restClient;
    public static final long MAX_EXPORT_LIMIT = 1000L;
    @NotNull
    public static final String USER_DRIVE_READ_PERMISSION = "user:drive.read";

    public DriveController(@NotNull SearchServiceInternalConnector searchServiceInternalConnector, @Value(value="${just.drive.api.baseUrl}") @NotNull String driveBaseUrl, @Qualifier(value="commonRequestInitializer") @NotNull ClientHttpRequestInitializer commonRequestInitializer, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)searchServiceInternalConnector, (String)"searchServiceInternalConnector");
        Intrinsics.checkNotNullParameter((Object)driveBaseUrl, (String)"driveBaseUrl");
        Intrinsics.checkNotNullParameter((Object)commonRequestInitializer, (String)"commonRequestInitializer");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        this.searchServiceInternalConnector = searchServiceInternalConnector;
        this.restClient = restClientBuilder.requestInitializer(commonRequestInitializer).baseUrl(driveBaseUrl).build();
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Returns a list of all downloadable Drive documents visible for the current user.", description="This route uses the permissions of the caller and is thus currently only available with the **OAuth 2.0 Password Flow** and **OAuth 2.0 Authorization Code Flow**\n\n**Needed Scopes:** user:drive.read")
    @ApiResponses(value={@ApiResponse(description="Successful", responseCode="200"), @ApiResponse(description="Request validation error: one or more inputs are invalid", responseCode="400")})
    @GetMapping(value={"documents"})
    @NotNull
    public List<DocumentExportDto> exportArticles(@Parameter(name="modifiedAfter", description="Return Drive documents modified after the given UTC datetime.", required=false, example="2018-02-26T02:00:00.000Z") @RequestParam(value="modifiedAfter", required=false) @Nullable Instant modifiedAfter, @Parameter(name="documentIds", description="Return documents only for the specified Ids", required=false) @RequestParam(value="documentIds", required=false) @Nullable List<DocumentId> documentIds, @Parameter(name="shareIds", description="Return documents only for the specified Shares", required=false) @RequestParam(value="shareIds", required=false) @Nullable List<DocumentId> shareIds, @Parameter(name="filetypes", description="Return documents only for the specified filetypes", required=false) @RequestParam(value="filetypes", required=false) @Nullable List<? extends SearchDriveFileType> filetypes, @Parameter(name="offset", description="Skip first n (offset) Drive documents to export.", required=false) @Min(value=0L, message="Offset must be a non-negative integer") @RequestParam(value="offset", required=false, defaultValue="0") int offset, @Parameter(name="limit", description="Max number of simultaneously loaded documents.", required=false) @Min(value=1L, message="Limit must be a positive integer less or equal to 1000") @Max(value=1000L, message="Limit must be a positive integer less or equal to 1000") @RequestParam(value="limit", required=false, defaultValue="50") int limit, @NotNull ProfileAuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.hasScope(USER_DRIVE_READ_PERMISSION)) {
            throw new MissingScopeException();
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$mapToSet$iv;
            void $this$mapTo$iv$iv3;
            void $this$mapToSet$iv2;
            Map map;
            Object item$iv$iv2;
            SortBy $this$mapTo$iv$iv4;
            Collection destination$iv$iv;
            Object object;
            Date date;
            Map p0;
            Object object2;
            SearchServiceInternalConnector searchServiceInternalConnector = this.searchServiceInternalConnector;
            ProfileId profileId = new ProfileId(((Number)authContext.getUser().getId()).longValue());
            TenantId tenantId = new TenantId((UUID)authContext.getTenantId().getId());
            Instant instant = modifiedAfter;
            if (instant != null) {
                Instant instant2 = instant;
                object2 = searchServiceInternalConnector;
                boolean $i$f$exportArticles$stub_for_inlining = false;
                boolean bl = false;
                date = Date.from((Instant)((Object)p0));
                searchServiceInternalConnector = object2;
            } else {
                date = null;
            }
            Object object3 = date;
            Set set = SetsKt.setOf((Object)SearchType.DRIVE_FILE);
            if (filetypes != null && !filetypes.isEmpty()) {
                Collection<String> collection;
                void $this$map$iv;
                Iterable $i$f$exportArticles$stub_for_inlining = filetypes;
                object = "FILE_TYPE";
                object2 = searchServiceInternalConnector;
                boolean $i$f$map = false;
                void var16_25 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    void it;
                    SearchDriveFileType searchDriveFileType = (SearchDriveFileType)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                collection = (List)destination$iv$iv;
                searchServiceInternalConnector = object2;
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)object, (Object)collection));
            } else {
                map = MapsKt.emptyMap();
            }
            p0 = map;
            Set set2 = SetsKt.setOf((Object)JustApp.DRIVE);
            SortDirection $i$f$map = SortDirection.DESC;
            $this$mapTo$iv$iv4 = SortBy.MODIFY_DATE;
            List<DocumentId> list = shareIds;
            Iterable $i$f$mapTo = list != null ? (Collection)list : (Collection)SetsKt.emptySet();
            object2 = searchServiceInternalConnector;
            boolean $i$f$mapToSet22 = false;
            item$iv$iv2 = $this$mapToSet$iv2;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void it;
                DocumentId documentId = (DocumentId)item$iv$iv3;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(SearchableId.Companion.fromCanonicalId(it.toString()));
            }
            destination$iv$iv = (Set)destination$iv$iv2;
            List<DocumentId> list2 = documentIds;
            Iterable $i$f$mapToSet22 = list2 != null ? (Collection)list2 : (Collection)SetsKt.emptySet();
            boolean $i$f$mapToSet = false;
            destination$iv$iv2 = $this$mapToSet$iv;
            Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
                void it;
                DocumentId bl = (DocumentId)item$iv$iv4;
                object = destination$iv$iv3;
                boolean bl2 = false;
                object.add(SearchableId.Companion.fromCanonicalId(it.toString()));
            }
            Set set3 = (Set)destination$iv$iv3;
            List searchResult = object2.search(new SearchParam(tenantId, profileId, null, set, set2, null, null, null, set3, null, (Set)destination$iv$iv, null, p0, null, (Date)object3, null, true, offset, limit, $this$mapTo$iv$iv4, $i$f$map, 43748, null)).getResults();
            if (searchResult.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = searchResult;
            boolean $i$f$map2 = false;
            object3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv) {
                void it;
                $this$mapTo$iv$iv4 = (SearchResult)item$iv$iv5;
                object2 = destination$iv$iv4;
                boolean bl = false;
                object2.add(DocumentExportDto.Companion.toDocumentExportDto((SearchResult)it));
            }
            return (List)destination$iv$iv4;
        }
        catch (RuntimeException e) {
            if (!(!(e.getCause() instanceof DataBufferLimitException))) {
                boolean bl = false;
                String string = "Too much data loaded. Reduce the limit to avoid this error. Current limit was: " + limit + ".";
                throw new IllegalArgumentException(string.toString());
            }
            throw e;
        }
    }

    @Operation(summary="Download the file with the given DocumentId.", description="This route uses the permissions of the caller and is thus currently only available with the **OAuth 2.0 Password Flow** and **OAuth 2.0 Authorization Code Flow**\n\n**Needed Scopes:** user:drive.read")
    @ApiResponses(value={@ApiResponse(description="Successful", responseCode="200"), @ApiResponse(description="Request validation error: one or more inputs are invalid", responseCode="400")})
    @GetMapping(value={"documents/{documentId}/download"})
    public void download(@Parameter(name="documentId", description="The id of the document to download", required=true, example="DRIVE_DOCUMENT,11111111-2222-3333-4444-555555555555") @PathVariable(value="documentId") @NotNull DocumentId documentId, @NotNull ProfileAuthContext authContext, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!authContext.hasScope(USER_DRIVE_READ_PERMISSION)) {
            throw new MissingScopeException();
        }
        this.restClient.get().uri("/documents/" + documentId.getId() + "/download", new Object[0]).exchange((arg_0, arg_1) -> DriveController.download$lambda$7(response, arg_0, arg_1));
    }

    private static final Unit download$lambda$7(HttpServletResponse $response, HttpRequest req, RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse clientResponse) {
        InputStream upstream = clientResponse.getBody();
        ServletOutputStream downstream = $response.getOutputStream();
        $response.setStatus(clientResponse.getStatusCode().value());
        HttpHeaders httpHeaders = clientResponse.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        Map $this$forEach$iv = (Map)httpHeaders;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)values);
            Iterable $this$forEach$iv2 = values;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                $response.addHeader(name, it);
            }
        }
        Intrinsics.checkNotNull((Object)upstream);
        Intrinsics.checkNotNull((Object)downstream);
        ByteStreamsKt.copyTo$default((InputStream)upstream, (OutputStream)((OutputStream)downstream), (int)0, (int)2, null);
        downstream.flush();
        return Unit.INSTANCE;
    }
}

