/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.network.OkHttpExtensionsKt;
import com.apollographql.apollo.network.http.HttpInterceptor;
import de.justsoftware.publicAPI.config.NewsGraphQLClient;
import jakarta.servlet.http.HttpServletRequest;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/publicAPI/config/NewsGraphQLClient;", "", "graphqlUrl", "", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "<init>", "(Ljava/lang/String;Lorg/springframework/boot/ssl/SslBundles;)V", "secureClient", "Lcom/apollographql/apollo/ApolloClient;", "withRequest", "request", "Ljakarta/servlet/http/HttpServletRequest;", "Companion", "public-api-service"})
public class NewsGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String graphqlUrl;
    @NotNull
    private final ApolloClient secureClient;

    public NewsGraphQLClient(@Value(value="${just.news.graphql.url}") @NotNull String graphqlUrl, @NotNull SslBundles sslBundles) {
        Intrinsics.checkNotNullParameter((Object)graphqlUrl, (String)"graphqlUrl");
        Intrinsics.checkNotNullParameter((Object)sslBundles, (String)"sslBundles");
        this.graphqlUrl = graphqlUrl;
        SslBundle sslBundle = sslBundles.getBundle("just");
        SSLContext sslContext = sslBundle.createSslContext();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSocketFactory(...)");
        TrustManager[] trustManagerArray = sslBundle.getManagers().getTrustManagers();
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getTrustManagers(...)");
        Object object = ArraysKt.first((Object[])trustManagerArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        OkHttpClient okHttpClient = builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)object).build();
        this.secureClient = OkHttpExtensionsKt.okHttpClient((ApolloClient.Builder)new ApolloClient.Builder().serverUrl(this.graphqlUrl), (OkHttpClient)okHttpClient).build();
    }

    @NotNull
    public ApolloClient withRequest(@NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.secureClient.newBuilder().addHttpInterceptor((HttpInterceptor)new Companion.GraphQLHttpInterceptor(request2)).build();
    }
}

