/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.rest.permission;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.permission.MonitoredService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Heartbeat")
public class HeartbeatController {
    private final ImmutableList<MonitoredService> _services;

    @Autowired
    public HeartbeatController(Collection<MonitoredService> monitoredServices) {
        this._services = ImmutableList.copyOf(monitoredServices);
    }

    @RequestMapping(value={"/heartbeat"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public ResponseEntity<Map<String, String>> heartbeat() {
        ImmutableMap serviceStates = (ImmutableMap)this._services.stream().sorted(Comparator.comparing(MonitoredService::getName)).collect(ImmutableMap.toImmutableMap(MonitoredService::getName, MonitoredService::getError));
        Map result = Maps.transformValues((Map)serviceStates, error -> error.orElse("OK"));
        HttpStatus statusCode = serviceStates.values().stream().allMatch(Optional.empty()::equals) ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.setAllow((Set)ImmutableSet.of((Object)HttpMethod.GET, (Object)HttpMethod.HEAD));
        return new ResponseEntity((Object)result, (MultiValueMap)httpHeaders, (HttpStatusCode)statusCode);
    }
}

