/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.permission.business.AuthorizationResult;
import de.justsoftware.permission.business.PermissionResolver;
import de.justsoftware.permission.business.config.ConfigService;
import de.justsoftware.permission.business.impl.PermissionResolverImpl;
import de.justsoftware.permission.business.item.ItemService;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.role.RoleService;
import de.justsoftware.permission.business.role.model.ApiRole;
import de.justsoftware.permission.business.role.model.ItemRoleWithId;
import de.justsoftware.permission.business.role.model.ItemRoleWithoutType;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.business.role.model.SearchRole;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionResolverImpl
implements PermissionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionResolverImpl.class);
    private final ConfigService _configService;
    private final RoleService _roleService;
    private final ItemService _itemService;

    @Autowired
    public PermissionResolverImpl(ConfigService configService, RoleService roleService, ItemService itemService) {
        this._configService = configService;
        this._roleService = roleService;
        this._itemService = itemService;
    }

    public ImmutableMap<ApiRole, AuthorizationResult> resolve(Set<? extends ApiRole> rolesToResolve, Set<? extends SearchRole> rolesOfUser) {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        AuthorizationResolveCalculator resolver = new AuthorizationResolveCalculator(this, rolesOfUser);
        rolesToResolve.forEach(arg_0 -> PermissionResolverImpl.lambda$resolve$1((ResolveCalculator)resolver, resultBuilder, arg_0));
        resolver.run();
        ImmutableMap result = resultBuilder.build();
        return (ImmutableMap)rolesToResolve.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), r -> (AuthorizationResult)result.getOrDefault(r, (Object)AuthorizationResult.NOT_ALLOWED)));
    }

    public ImmutableSetMultimap<ItemRoleWithId, SearchRole> resolve(Set<ItemRoleWithId> rolesToResolve) {
        ImmutableSetMultimap.Builder resultBuilder = ImmutableSetMultimap.builder();
        VisibilitiesResolveCalculator resolver = new VisibilitiesResolveCalculator(this);
        rolesToResolve.forEach(arg_0 -> PermissionResolverImpl.lambda$resolve$4((ResolveCalculator)resolver, resultBuilder, arg_0));
        resolver.run();
        return resultBuilder.build();
    }

    public ImmutableSetMultimap<ItemId, SearchRole> visibility(Set<ItemId> itemIds) {
        ImmutableSet readRoles = (ImmutableSet)itemIds.stream().map(arg_0 -> ((ItemRoleWithoutType)ItemRoleWithoutType.READ).withItem(arg_0)).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap result = this.resolve((Set)readRoles);
        return (ImmutableSetMultimap)itemIds.stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Function.identity(), i -> result.get((Object)ItemRoleWithoutType.READ.withItem(i)).stream()));
    }

    private static /* synthetic */ void lambda$resolve$4(ResolveCalculator resolver, ImmutableSetMultimap.Builder resultBuilder, ItemRoleWithId role) {
        resolver.startResolve((Role)role, (result, roles) -> resultBuilder.putAll((Object)role, (Iterable)roles));
    }

    private static /* synthetic */ void lambda$resolve$1(ResolveCalculator resolver, ImmutableMap.Builder resultBuilder, ApiRole role) {
        resolver.startResolve((Role)role, (result, roles) -> resultBuilder.put((Object)role, (Object)result));
    }
}

