/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission;

import io.micrometer.observation.ObservationPredicate;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.observation.ServerRequestObservationContext;

@Configuration
@ConditionalOnEnabledTracing
public class MonitoringConfiguration {
    @Bean
    ObservationPredicate noMonitoringObservations() {
        return (name, context) -> {
            if (name.equals("http.server.requests") && context instanceof ServerRequestObservationContext) {
                ServerRequestObservationContext serverContext = (ServerRequestObservationContext)context;
                return !((HttpServletRequest)serverContext.getCarrier()).getRequestURI().contains("/internal/monitoring");
            }
            return true;
        };
    }
}

