/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.util;

import de.justsoftware.news.util.NodeContext;
import de.justsoftware.news.util.Op;
import de.justsoftware.news.util.Quill2XmlConverter;
import de.justsoftware.news.util.QuillDelta;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n0\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0016\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/news/util/Quill2XmlConverter;", "", "<init>", "()V", "toXml", "Lkotlin/Pair;", "", "", "", "Lde/justsoftware/news/util/NodeContext;", "Lde/justsoftware/news/util/Context;", "quillDelta", "Lde/justsoftware/news/util/QuillDelta;", "toQuillDelta", "xmlContent", "context", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nQuill2XmlConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quill2XmlConverter.kt\nde/justsoftware/news/util/Quill2XmlConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1878#2,3:122\n*S KotlinDebug\n*F\n+ 1 Quill2XmlConverter.kt\nde/justsoftware/news/util/Quill2XmlConverter\n*L\n29#1:122,3\n*E\n"})
public class Quill2XmlConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String XML_TAG_NAME_TEXT = "text";
    @NotNull
    public static final String XML_TAG_NAME_META = "meta";
    private static final Logger LOG = LoggerFactory.getLogger(Quill2XmlConverter.class);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<String, Map<Integer, NodeContext>> toXml(@NotNull QuillDelta quillDelta) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)quillDelta, (String)"quillDelta");
        HashMap context = new HashMap();
        StringBuilder $this$toXml_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toXml_u24lambda_u241.append("<doc>");
        Iterable $this$forEachIndexed$iv = quillDelta.getOps();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void op;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Op op2 = (Op)item$iv;
            int idx = n;
            boolean bl2 = false;
            Object object = op.getInsert();
            if (object instanceof String) {
                $this$toXml_u24lambda_u241.append("<");
                $this$toXml_u24lambda_u241.append(XML_TAG_NAME_TEXT);
                $this$toXml_u24lambda_u241.append(" id=\"" + idx + "\">");
                $this$toXml_u24lambda_u241.append(StringEscapeUtils.escapeXml11((String)((String)op.getInsert())));
                $this$toXml_u24lambda_u241.append("</");
                $this$toXml_u24lambda_u241.append(XML_TAG_NAME_TEXT);
                $this$toXml_u24lambda_u241.append(">");
                Integer n2 = idx;
                ((Map)context).put(n2, new NodeContext(null, op.getAttributes()));
                continue;
            }
            if (!(object instanceof Map)) continue;
            $this$toXml_u24lambda_u241.append("<");
            $this$toXml_u24lambda_u241.append(XML_TAG_NAME_META);
            $this$toXml_u24lambda_u241.append(" id=\"" + idx + "\"/>");
            Object object2 = op.getInsert();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map insertData = (Map)object2;
            Integer n3 = idx;
            ((Map)context).put(n3, new NodeContext(insertData, op.getAttributes()));
        }
        $this$toXml_u24lambda_u241.append("</doc>");
        String xmlContent = stringBuilder.toString();
        return TuplesKt.to((Object)xmlContent, context);
    }

    @NotNull
    public QuillDelta toQuillDelta(@NotNull String xmlContent, @NotNull Map<Integer, NodeContext> context) {
        Intrinsics.checkNotNullParameter((Object)xmlContent, (String)"xmlContent");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        byte[] byArray = xmlContent.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        ArrayList<Op> ops = new ArrayList<Op>();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getChildNodes(...)");
        NodeList list = nodeList;
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            Node node2 = node;
            if (node2 instanceof Element) {
                String id = ((Element)node).getAttribute("id");
                Intrinsics.checkNotNull((Object)id);
                NodeContext nodeContext = context.get(Integer.parseInt(id));
                String string = ((Element)node).getNodeName();
                if (Intrinsics.areEqual((Object)string, (Object)XML_TAG_NAME_TEXT)) {
                    String string2 = ((Element)node).getTextContent();
                    if (string2 == null) {
                        string2 = "";
                    }
                    String content = string2;
                    NodeContext nodeContext2 = nodeContext;
                    ops.add(new Op((Object)content, nodeContext2 != null ? nodeContext2.getAttributes() : null));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)XML_TAG_NAME_META)) {
                    NodeContext nodeContext3 = nodeContext;
                    NodeContext nodeContext4 = nodeContext;
                    ops.add(new Op((Object)(nodeContext3 != null ? nodeContext3.getInsertData() : null), nodeContext4 != null ? nodeContext4.getAttributes() : null));
                    continue;
                }
                LOG.warn("Encountered unexpected element of type " + ((Element)node).getNodeName());
                continue;
            }
            if (node2 instanceof Text) {
                if (ops.isEmpty()) {
                    LOG.warn("Encountered text node before any translated content");
                    continue;
                }
                Object e = ops.get(CollectionsKt.getLastIndex((List)ops));
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Op prevOp = (Op)e;
                if (prevOp.getInsert() instanceof String) {
                    ops.set(CollectionsKt.getLastIndex((List)ops), Op.copy$default((Op)prevOp, (Object)(prevOp.getInsert() + ((Text)node).getTextContent()), null, (int)2, null));
                    continue;
                }
                LOG.warn("previous Op does not have any text to append to");
                continue;
            }
            LOG.warn("Encountered unexpected node of type " + node.getNodeName());
        }
        return new QuillDelta((List)ops);
    }
}

