/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.rest;

import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.comment.CommentWithTenantId;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.UserId;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/news/rest/InternalRepublishService;", "", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "log", "Lorg/slf4j/Logger;", "republishAll", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nInternalRepublishService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalRepublishService.kt\nde/justsoftware/news/rest/InternalRepublishService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1869#2:88\n1869#2,2:89\n1870#2:91\n*S KotlinDebug\n*F\n+ 1 InternalRepublishService.kt\nde/justsoftware/news/rest/InternalRepublishService\n*L\n32#1:88\n36#1:89,2\n32#1:91\n*E\n"})
public class InternalRepublishService {
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final Logger log;

    public InternalRepublishService(@NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull ChannelRepo channelRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull PostCommentRepo postCommentRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.channelPermissionRepo = channelPermissionRepo;
        this.channelRepo = channelRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.postCommentRepo = postCommentRepo;
        this.postRepo = postRepo;
        Logger logger = LoggerFactory.getLogger(InternalRepublishService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void republishAll() {
        Set channels = this.channelRepo.getAllByDeletedFalse();
        this.log.info("Start republish channels");
        Set it = channels;
        boolean bl = false;
        this.permissionKafkaProducer.republish(ItemId.Type.CHANNEL, () -> InternalRepublishService.republishAll$lambda$3$lambda$2(it, this));
        this.log.info("Start republish posts");
        AutoCloseable autoCloseable = this.postRepo.findByDeletedFalse();
        Throwable throwable = null;
        try {
            Stream posts2 = (Stream)autoCloseable;
            boolean bl2 = false;
            this.permissionKafkaProducer.republish(ItemId.Type.POST, () -> InternalRepublishService.republishAll$lambda$7$lambda$6(posts2, this));
            posts2 = Unit.INSTANCE;
        }
        catch (Throwable bl2) {
            throwable = bl2;
            throw bl2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.log.info("Start republish comments");
        autoCloseable = this.postCommentRepo.getAllWhichHaveAttachments();
        throwable = null;
        try {
            Stream it2 = (Stream)autoCloseable;
            boolean bl3 = false;
            this.permissionKafkaProducer.republish(ItemId.Type.COMMENT, () -> InternalRepublishService.republishAll$lambda$11$lambda$10(it2, this));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.log.info("Finish republishing");
    }

    /*
     * WARNING - void declaration
     */
    private static final void republishAll$lambda$3$lambda$2(Set $it, InternalRepublishService this$0) {
        Iterable $this$forEach$iv = $it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            Channel channel = (Channel)element$iv;
            boolean bl = false;
            this$0.permissionKafkaProducer.publishChannel(channel);
            Iterable iterable = this$0.channelPermissionRepo.findAllByChannelId(channel.getId());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ChannelPermission it = (ChannelPermission)element$iv2;
                boolean bl2 = false;
                this$0.permissionKafkaProducer.publishChannelPermission(it);
            }
        }
    }

    private static final Unit republishAll$lambda$7$lambda$6$lambda$4(InternalRepublishService this$0, Post post) {
        this$0.permissionKafkaProducer.publishPost(post.getId(), post.getChannelId(), post.getPublished());
        this$0.permissionKafkaProducer.publishPermission(new PermissionItem((ItemId)post.getId(), (UserId)post.getAuthorId(), PermissionRole.MANAGER));
        return Unit.INSTANCE;
    }

    private static final void republishAll$lambda$7$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void republishAll$lambda$7$lambda$6(Stream $posts, InternalRepublishService this$0) {
        $posts.forEach(arg_0 -> InternalRepublishService.republishAll$lambda$7$lambda$6$lambda$5(arg_0 -> InternalRepublishService.republishAll$lambda$7$lambda$6$lambda$4(this$0, arg_0), arg_0));
    }

    private static final Unit republishAll$lambda$11$lambda$10$lambda$8(InternalRepublishService this$0, CommentWithTenantId comment) {
        this$0.permissionKafkaProducer.publishComment(comment.getId(), comment.getPostId());
        this$0.permissionKafkaProducer.publishPermission(new PermissionItem((ItemId)comment.getId(), (UserId)comment.getAuthorId(), PermissionRole.MANAGER));
        return Unit.INSTANCE;
    }

    private static final void republishAll$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void republishAll$lambda$11$lambda$10(Stream $it, InternalRepublishService this$0) {
        $it.forEach(arg_0 -> InternalRepublishService.republishAll$lambda$11$lambda$10$lambda$9(arg_0 -> InternalRepublishService.republishAll$lambda$11$lambda$10$lambda$8(this$0, arg_0), arg_0));
    }
}

