/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollService;
import de.justsoftware.news.domain.poll.PollTranslationService;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PollAnswerId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.PollVoteId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0011H\u0017J.\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\u0006\u0010#\u001a\u00020\u0014H\u0017J\u0010\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0014H\u0017J2\u0010&\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/news/domain/poll/PollService;", "", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "pollTranslationService", "Lde/justsoftware/news/domain/poll/PollTranslationService;", "<init>", "(Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/poll/PollTranslationService;)V", "vote", "Lde/justsoftware/news/domain/poll/Poll;", "pollId", "Lde/justsoftware/news/id/PollId;", "yesAnswers", "", "Lde/justsoftware/news/id/PollAnswerId;", "targetLanguage", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "getById", "id", "findPollByPostId", "postId", "Lde/justsoftware/news/id/PostId;", "sourceLanguage", "findAnswersByPollId", "Lde/justsoftware/news/domain/poll/PollAnswer;", "findVotesByAnswerId", "Lde/justsoftware/news/domain/poll/PollVote;", "pollAnswerId", "voteCountByAnswerId", "", "findVotesToAnswerIds", "", "", "pollAnswerIds", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nPollService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollService.kt\nde/justsoftware/news/domain/poll/PollService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1869#2,2:116\n1056#2:118\n1563#2:119\n1634#2,3:120\n1285#2,2:123\n1299#2,2:125\n774#2:128\n865#2,2:129\n1302#2:131\n1#3:127\n*S KotlinDebug\n*F\n+ 1 PollService.kt\nde/justsoftware/news/domain/poll/PollService\n*L\n41#1:116,2\n75#1:118\n100#1:119\n100#1:120,3\n102#1:123,2\n102#1:125,2\n105#1:128\n105#1:129,2\n102#1:131\n*E\n"})
public class PollService {
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PollTranslationService pollTranslationService;

    public PollService(@NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo, @NotNull PostRepo postRepo, @NotNull PollTranslationService pollTranslationService) {
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)pollTranslationService, (String)"pollTranslationService");
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
        this.postRepo = postRepo;
        this.pollTranslationService = pollTranslationService;
    }

    @Transactional
    @NotNull
    public Poll vote(@NotNull PollId pollId, @NotNull List<PollAnswerId> yesAnswers, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(yesAnswers, (String)"yesAnswers");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Poll poll = this.pollRepo.getById(pollId);
        Post post = this.postRepo.getByIdAndDeletedFalse(poll.getPostId());
        authContext.checkPostAction(post, PostAction.VOTE);
        this.pollVoteRepo.deleteAllByPollIdAndProfileId(poll.getId(), authContext.getUser());
        Instant voteDate = Instant.now();
        Iterable $this$forEach$iv = yesAnswers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PollAnswerId it = (PollAnswerId)element$iv;
            boolean bl = false;
            PollVoteId pollVoteId = PollVoteId.Companion.random();
            PollId pollId2 = poll.getId();
            ProfileId profileId = authContext.getUser();
            Intrinsics.checkNotNull((Object)voteDate);
            this.pollVoteRepo.insert(pollVoteId, pollId2, it, profileId, voteDate);
        }
        return this.pollTranslationService.translate(poll, post.getSourceLanguage(), targetLanguage, authContext);
    }

    public static /* synthetic */ Poll vote$default(PollService pollService, PollId pollId, List list, String string, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: vote");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return pollService.vote(pollId, list, string, authorizationContext);
    }

    @Unauthorized
    @NotNull
    public Poll getById(@NotNull PollId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.pollRepo.getById(id);
    }

    @Unauthorized
    @Nullable
    public Poll findPollByPostId(@NotNull PostId postId, @Nullable String sourceLanguage, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Poll poll;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Poll poll2 = this.pollRepo.findByPostId(postId);
        if (poll2 != null) {
            Poll poll3 = poll2;
            boolean bl = false;
            poll = this.pollTranslationService.translate(poll3, sourceLanguage, targetLanguage, authContext);
        } else {
            poll = null;
        }
        return poll;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<PollAnswer> findAnswersByPollId(@NotNull PollId pollId, @Nullable String sourceLanguage, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Iterable iterable = this.pollAnswerRepo.findAllByPollId(pollId);
        boolean $i$f$sortedBy = false;
        List<PollAnswer> list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)).parallelStream().map(arg_0 -> PollService.findAnswersByPollId$lambda$4(arg_0 -> PollService.findAnswersByPollId$lambda$3(this, sourceLanguage, targetLanguage, authContext, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Unauthorized
    @NotNull
    public List<PollVote> findVotesByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.findByAnswerId(pollAnswerId);
    }

    @Unauthorized
    public int voteCountByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.countByAnswerId(pollAnswerId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PollAnswerId, Set<PollVote>> findVotesToAnswerIds(@NotNull Collection<PollAnswerId> pollAnswerIds, @NotNull AuthorizationContext authContext) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable answersForBatch;
        Intrinsics.checkNotNullParameter(pollAnswerIds, (String)"pollAnswerIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set uniqueAnswerIds = CollectionsKt.toSet((Iterable)pollAnswerIds);
        Set votesForBatch = this.pollVoteRepo.findByAnswerIdIn(uniqueAnswerIds);
        Iterable iterable = this.pollAnswerRepo.findAllById((Iterable)pollAnswerIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        Iterable iterable2 = answersForBatch = iterable;
        Object object = this.pollRepo;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPollId());
        }
        Iterable iterable3 = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"findAllById(...)");
        List pollsForBatch = CollectionsKt.distinct((Iterable)iterable3);
        Iterable $this$associateWith$iv = uniqueAnswerIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            Object v4;
            void answerId;
            Object object2;
            Object bl;
            block14: {
                PollId pollId;
                Object v2;
                PollAnswer it;
                Iterator iterator;
                block13: {
                    Object item$iv$iv;
                    item$iv$iv = (PollAnswerId)element$iv$iv;
                    collection = element$iv$iv;
                    object = result$iv;
                    boolean bl2 = false;
                    bl = answersForBatch;
                    iterator = bl.iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        it = (PollAnswer)object2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)answerId)) continue;
                        v2 = object2;
                        break block13;
                    }
                    v2 = null;
                }
                PollAnswer pollAnswer = v2;
                if ((pollAnswer != null ? pollAnswer.getPollId() : null) == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                pollId = pollId;
                bl = pollsForBatch;
                iterator = bl.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    it = (Poll)object2;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)pollId)) continue;
                    v4 = object2;
                    break block14;
                }
                v4 = null;
            }
            if (v4 == null) {
                bl = "Required value was null.";
                throw new IllegalArgumentException(bl.toString());
            }
            Poll poll = v4;
            Iterable $this$filter$iv = votesForBatch;
            boolean $i$f$filter = false;
            object2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                PollVote vote = (PollVote)element$iv$iv2;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)vote.getAnswerId(), (Object)answerId)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Set votes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            Set set = switch (WhenMappings.$EnumSwitchMapping$0[poll.getPrivacy().ordinal()]) {
                case 1 -> null;
                case 2 -> {
                    if (authContext.mayManage((ItemId)poll.getPostId())) {
                        yield votes;
                    }
                    yield null;
                }
                case 3 -> votes;
                default -> throw new NoWhenBranchMatchedException();
            };
            object.put(collection, set);
        }
        return result$iv;
    }

    private static final PollAnswer findAnswersByPollId$lambda$3(PollService this$0, String $sourceLanguage, String $targetLanguage, AuthorizationContext $authContext, PollAnswer answer) {
        PollTranslationService pollTranslationService = this$0.pollTranslationService;
        Intrinsics.checkNotNull((Object)answer);
        return pollTranslationService.translate(answer, $sourceLanguage, $targetLanguage, $authContext);
    }

    private static final PollAnswer findAnswersByPollId$lambda$4(Function1 $tmp0, Object p0) {
        return (PollAnswer)$tmp0.invoke(p0);
    }
}

