/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H'J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H&J(\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010H'J*\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\f\u001a\u00020\rH'J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H'J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH&J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\n\u001a\u00020\u000bH'J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH&J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH&J(\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\rH'J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H&J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006)\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/news/domain/channel/ChannelRepo;", "Lorg/springframework/data/repository/CrudRepository;", "Lde/justsoftware/news/domain/channel/Channel;", "Lde/justsoftware/news/id/ChannelId;", "Lorg/springframework/data/repository/PagingAndSortingRepository;", "insert", "", "id", "title", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "modifyDate", "Ljava/time/Instant;", "createDate", "createdBy", "Lde/justsoftware/news/id/ProfileId;", "getByIdAndDeletedFalse", "updateTitle", "editedBy", "updateOnlyManagersMayPin", "onlyManagersMayPin", "", "getAllNotDeletedIds", "", "getByIdInAndDeletedFalse", "ids", "", "getIdsByTenant", "getByTenantIdAndDeletedFalse", "getByTenantIdAndDeletedFalseOrderByTitleAsc", "", "findAllByIdInAndDeletedFalse", "updateDeleted", "deleted", "deletedBy", "deletedAt", "getAllByDeletedFalse", "deleteMarked", "", "timeToDelete", "news-service"})
public interface ChannelRepo
extends CrudRepository<Channel, ChannelId>,
PagingAndSortingRepository<Channel, ChannelId> {
    @Modifying
    @Query(value="\n        INSERT INTO channel (id, title, tenant_id, deleted, modify_date, create_date, created_by)\n        VALUES(:id, :title, :tenantId, false, :modifyDate, :createDate, :createdBy)\n    ")
    public void insert(@NotNull ChannelId var1, @NotNull String var2, @NotNull TenantId var3, @NotNull Instant var4, @NotNull Instant var5, @NotNull ProfileId var6);

    @NotNull
    public Channel getByIdAndDeletedFalse(@NotNull ChannelId var1);

    @Modifying
    @Query(value="\n        UPDATE channel\n        SET title = :title,\n            modify_date = :modifyDate,\n            edited_by = :editedBy\n        WHERE id = :id\n        ")
    public void updateTitle(@NotNull ChannelId var1, @NotNull String var2, @NotNull Instant var3, @NotNull ProfileId var4);

    @Modifying
    @Query(value="\n        UPDATE channel\n        SET only_managers_may_pin = :onlyManagersMayPin,\n            modify_date = :modifyDate,\n            edited_by = :editedBy\n        WHERE id = :id\n        ")
    public void updateOnlyManagersMayPin(@NotNull ChannelId var1, boolean var2, @NotNull ProfileId var3, @NotNull Instant var4);

    public static /* synthetic */ void updateOnlyManagersMayPin$default(ChannelRepo channelRepo, ChannelId channelId, boolean bl, ProfileId profileId, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateOnlyManagersMayPin");
        }
        if ((n & 8) != 0) {
            instant = Instant.now();
        }
        channelRepo.updateOnlyManagersMayPin(channelId, bl, profileId, instant);
    }

    @Query(value="Select id FROM channel WHERE deleted = false")
    @NotNull
    public Set<ChannelId> getAllNotDeletedIds();

    @NotNull
    public Set<Channel> getByIdInAndDeletedFalse(@NotNull Collection<ChannelId> var1);

    @Query(value="Select id FROM channel WHERE deleted = false AND tenant_id = :tenantId")
    @NotNull
    public Set<ChannelId> getIdsByTenant(@NotNull TenantId var1);

    @NotNull
    public Set<Channel> getByTenantIdAndDeletedFalse(@NotNull TenantId var1);

    @NotNull
    public List<Channel> getByTenantIdAndDeletedFalseOrderByTitleAsc(@NotNull TenantId var1);

    @NotNull
    public Set<Channel> findAllByIdInAndDeletedFalse(@NotNull Collection<ChannelId> var1);

    @Modifying
    @Query(value="\n        UPDATE channel\n        SET deleted = :deleted, deleted_by = :deletedBy, deleted_at = :deletedAt\n        WHERE id = :id\n        ")
    public void updateDeleted(@NotNull ChannelId var1, boolean var2, @NotNull ProfileId var3, @NotNull Instant var4);

    @NotNull
    public Set<Channel> getAllByDeletedFalse();

    @Modifying
    @Query(value="DELETE FROM channel WHERE deleted = true AND deleted_at < :timeToDelete")
    public int deleteMarked(@NotNull Instant var1);
}

