/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.AllowedChannelActionsDataLoader;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.LatestPublishAtDataLoader;
import de.justsoftware.news.domain.channel.ManagedSubscriptionDataLoader;
import de.justsoftware.news.domain.channel.PermissionsByChannelIdDataLoader;
import de.justsoftware.news.domain.channel.SubscriptionDataLoader;
import de.justsoftware.news.domain.subscription.ChannelSubscriptionService;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.UserDataLoaderKt;
import de.justsoftware.news.graphql.generated.types.Channel;
import de.justsoftware.news.graphql.generated.types.ChannelPermission;
import de.justsoftware.news.graphql.generated.types.ChannelSubscription;
import de.justsoftware.news.graphql.generated.types.ManagedSubscription;
import de.justsoftware.news.id.ChannelId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017JG\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\b0\u00072\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00072\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001e\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/channel/ChannelDataFetcher;", "", "channelSubscriptionService", "Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "<init>", "(Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;)V", "permissions", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/graphql/generated/types/ChannelPermission;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "subscribers", "Lde/justsoftware/news/graphql/generated/types/Profile;", "offset", "", "limit", "query", "", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;)Ljava/util/concurrent/CompletableFuture;", "subscribersCount", "subscription", "Lde/justsoftware/news/graphql/generated/types/ChannelSubscription;", "managedSubscriptions", "Lde/justsoftware/news/graphql/generated/types/ManagedSubscription;", "allowedActions", "", "Lde/justsoftware/news/domain/channel/ChannelAction;", "latestPublishAt", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nChannelDataFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelDataFetcher.kt\nde/justsoftware/news/domain/channel/ChannelDataFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1563#2:260\n1634#2,3:261\n*S KotlinDebug\n*F\n+ 1 ChannelDataFetcher.kt\nde/justsoftware/news/domain/channel/ChannelDataFetcher\n*L\n115#1:260\n115#1:261,3\n*E\n"})
public class ChannelDataFetcher {
    @NotNull
    private final ChannelSubscriptionService channelSubscriptionService;

    public ChannelDataFetcher(@NotNull ChannelSubscriptionService channelSubscriptionService) {
        Intrinsics.checkNotNullParameter((Object)channelSubscriptionService, (String)"channelSubscriptionService");
        this.channelSubscriptionService = channelSubscriptionService;
    }

    @DgsData(parentType="Channel", field="permissions")
    @NotNull
    public CompletableFuture<List<ChannelPermission>> permissions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PermissionsByChannelIdDataLoader.class);
        ChannelId channelId = ((Channel)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscribers")
    @NotNull
    public CompletableFuture<List<de.justsoftware.news.graphql.generated.types.Profile>> subscribers(@InputArgument @Nullable Integer offset, @InputArgument @Nullable Integer limit, @InputArgument @Nullable String query, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        CompletableFuture<List<de.justsoftware.news.graphql.generated.types.Profile>> completableFuture = CompletableFuture.supplyAsync(() -> ChannelDataFetcher.subscribers$lambda$1(dfe, this, limit, offset, query));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscribersCount")
    @NotNull
    public CompletableFuture<Integer> subscribersCount(@InputArgument @Nullable String query, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        CompletableFuture<Integer> completableFuture = CompletableFuture.supplyAsync(() -> ChannelDataFetcher.subscribersCount$lambda$2(dfe, this, query));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscription")
    @NotNull
    public CompletableFuture<List<ChannelSubscription>> subscription(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(SubscriptionDataLoader.class);
        ChannelId channelId = ((Channel)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="managedSubscriptions")
    @NotNull
    public CompletableFuture<List<ManagedSubscription>> managedSubscriptions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ManagedSubscriptionDataLoader.class);
        ChannelId channelId = ((Channel)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<ChannelAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ChannelId channelId = ((Channel)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(AllowedChannelActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="latestPublishAt")
    @NotNull
    public CompletableFuture<Long> latestPublishAt(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ChannelId channelId = ((Channel)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(LatestPublishAtDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private static final List subscribers$lambda$1(DgsDataFetchingEnvironment $dfe, ChannelDataFetcher this$0, Integer $limit, Integer $offset, String $query) {
        List list;
        AuthorizationContext authCtx = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)$dfe);
        ChannelId channelId = ((Channel)$dfe.getSourceOrThrow()).getId();
        List list2 = this$0.channelSubscriptionService.findSubscribersForChannelId(channelId, $limit, $offset, $query, authCtx);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void profile;
                Profile profile2 = (Profile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UserDataLoaderKt.toGql((Profile)profile));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private static final Integer subscribersCount$lambda$2(DgsDataFetchingEnvironment $dfe, ChannelDataFetcher this$0, String $query) {
        AuthorizationContext authCtx = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)$dfe);
        ChannelId channelId = ((Channel)$dfe.getSourceOrThrow()).getId();
        return this$0.channelSubscriptionService.countSubscribersForChannel(channelId, $query, authCtx);
    }
}

