/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.permission;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 22\u00020\u0001:\u00012B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\u00020\u000e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*H\u0016J\u0016\u0010+\u001a\u00020\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\u0018\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemProducer;", "permissionCleaningProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "singleRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentProducer;", "<init>", "(Lde/justsoftware/permission/client/kafka/PermissionItemProducer;Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentProducer;)V", "publishConfig", "", "publishChannelPermission", "Lde/justsoftware/news/kafka/KafkaPublishOperation;", "channelPermission", "Lde/justsoftware/news/domain/channel/permission/ChannelPermission;", "publishPermission", "permission", "Lde/justsoftware/news/connector/permission/PermissionItem;", "publishPermissions", "addedPermissions", "", "publishChannel", "channel", "Lde/justsoftware/news/domain/channel/Channel;", "publishComment", "commentId", "Lde/justsoftware/news/id/CommentId;", "parent", "Lde/justsoftware/news/id/PostId;", "publishPost", "postId", "channelId", "Lde/justsoftware/news/id/ChannelId;", "published", "", "deleteItem", "itemId", "Lde/justsoftware/news/id/ItemId;", "deleteItems", "itemIds", "", "deletePermissions", "deletedPermissions", "republish", "type", "Lde/justsoftware/news/id/ItemId$Type;", "doRepublish", "Ljava/lang/Runnable;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPermissionKafkaProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionKafkaProducer.kt\nde/justsoftware/news/connector/permission/PermissionKafkaProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1563#2:149\n1634#2,3:150\n1563#2:154\n1634#2,3:155\n1#3:153\n*S KotlinDebug\n*F\n+ 1 PermissionKafkaProducer.kt\nde/justsoftware/news/connector/permission/PermissionKafkaProducer\n*L\n84#1:149\n84#1:150,3\n121#1:154\n121#1:155,3\n*E\n"})
public class PermissionKafkaProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionItemProducer permissionItemProducer;
    @NotNull
    private final KafkaCleaningProducer<String, String> permissionCleaningProducer;
    @NotNull
    private final SingleRoleAssignmentProducer singleRoleAssignmentProducer;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String TOPIC = "just.permission.config";
    @NotNull
    private static final String CONFIG_FILE_PATH = "/news-permission-config.json";

    public PermissionKafkaProducer(@NotNull PermissionItemProducer permissionItemProducer, @NotNull KafkaCleaningProducer<String, String> permissionCleaningProducer, @NotNull SingleRoleAssignmentProducer singleRoleAssignmentProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionItemProducer, (String)"permissionItemProducer");
        Intrinsics.checkNotNullParameter(permissionCleaningProducer, (String)"permissionCleaningProducer");
        Intrinsics.checkNotNullParameter((Object)singleRoleAssignmentProducer, (String)"singleRoleAssignmentProducer");
        this.permissionItemProducer = permissionItemProducer;
        this.permissionCleaningProducer = permissionCleaningProducer;
        this.singleRoleAssignmentProducer = singleRoleAssignmentProducer;
    }

    public void publishConfig() {
        URL config;
        log.info("Sending Permission Config to TOPIC: 'just.permission.config'");
        URL uRL = this.getClass().getResource(CONFIG_FILE_PATH);
        if (uRL == null) {
            boolean bl = false;
            String string = "Cant find file '/news-permission-config.json' in resources";
            throw new IllegalArgumentException(string.toString());
        }
        URL uRL2 = config = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        this.permissionCleaningProducer.send(new ProducerRecord(TOPIC, (Object)"CHANNEL", (Object)new String(byArray, charset)));
    }

    @NotNull
    public KafkaPublishOperation publishChannelPermission(@NotNull ChannelPermission channelPermission) {
        Intrinsics.checkNotNullParameter((Object)channelPermission, (String)"channelPermission");
        Role grantedRole = switch (WhenMappings.$EnumSwitchMapping$0[channelPermission.getRole().ordinal()]) {
            case 1 -> Role.reader((String)channelPermission.getChannelId().toTypedString());
            case 2 -> Role.writer((String)channelPermission.getChannelId().toTypedString());
            case 3 -> Role.manager((String)channelPermission.getChannelId().toTypedString());
            default -> throw new NoWhenBranchMatchedException();
        };
        Role granteeRole = Role.create((String)channelPermission.getGranteeId().toTypedString());
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.addRoleReplacement(grantedRole, granteeRole);
        Intrinsics.checkNotNull((Object)waitForOffsets);
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation publishPermission(@NotNull PermissionItem permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return this.publishPermissions(CollectionsKt.listOf((Object)permission));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation publishPermissions(@NotNull List<PermissionItem> addedPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addedPermissions, (String)"addedPermissions");
        Iterable $this$map$iv = addedPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionItem permissionItem = (PermissionItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.singleRoleAssignmentProducer.addRoleReplacement(Role.itemRole((String)it.getRole().name(), (String)it.getItemId().toTypedString()), Role.create((String)it.getGranteeId().toTypedString())));
        }
        Stream it = ((List)destination$iv$iv).stream();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        return new KafkaPublishOperation(it);
    }

    @NotNull
    public KafkaPublishOperation publishChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem(channel.getId().toTypedString(), Optional.of(channel.getTenantId().toTypedString()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"publishItem(...)");
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation publishComment(@NotNull CommentId commentId, @NotNull PostId parent) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem(commentId.toTypedString(), Optional.of(parent.toTypedString()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"publishItem(...)");
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation publishPost(@NotNull PostId postId, @NotNull ChannelId channelId, boolean published) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String[] stringArray = new String[]{!published ? "SCHEDULED" : null};
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem(postId.toTypedString(), Optional.of(channelId.toTypedString()), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"publishItem(...)");
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation deleteItem(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.deleteItems(SetsKt.setOf((Object)itemId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation deleteItems(@NotNull Set<? extends ItemId> itemIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable $this$map$iv = itemIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.permissionItemProducer.publishDeletedItem(it.toTypedString()));
        }
        Stream it = ((List)destination$iv$iv).stream();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        return new KafkaPublishOperation(it);
    }

    @NotNull
    public KafkaPublishOperation deletePermissions(@NotNull List<PermissionItem> deletedPermissions) {
        Intrinsics.checkNotNullParameter(deletedPermissions, (String)"deletedPermissions");
        Stream<WaitForOffsets> it = deletedPermissions.stream().map(arg_0 -> PermissionKafkaProducer.deletePermissions$lambda$6(arg_0 -> PermissionKafkaProducer.deletePermissions$lambda$5(this, arg_0), arg_0));
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        return new KafkaPublishOperation(it);
    }

    public void republish(@NotNull ItemId.Type type, @NotNull Runnable doRepublish) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)doRepublish, (String)"doRepublish");
        this.permissionItemProducer.republish(type.name(), () -> PermissionKafkaProducer.republish$lambda$8(this, type, doRepublish));
    }

    private static final WaitForOffsets deletePermissions$lambda$5(PermissionKafkaProducer this$0, PermissionItem it) {
        return this$0.singleRoleAssignmentProducer.deleteRoleReplacement(Role.itemRole((String)it.getRole().name(), (String)it.getItemId().toTypedString()), Role.create((String)it.getGranteeId().toTypedString()));
    }

    private static final WaitForOffsets deletePermissions$lambda$6(Function1 $tmp0, Object p0) {
        return (WaitForOffsets)$tmp0.invoke(p0);
    }

    private static final void republish$lambda$8(PermissionKafkaProducer this$0, ItemId.Type $type, Runnable $doRepublish) {
        this$0.singleRoleAssignmentProducer.republishForAllItemRoles($type.name(), $doRepublish);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PermissionKafkaProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

