/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.app.service.AppService;
import de.justsoftware.mobile.gateway.notification.model.ApiChangeList;
import de.justsoftware.mobile.gateway.notification.model.ChangeList;
import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationSyncToken;
import de.justsoftware.mobile.gateway.notification.model.PushToken;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0016\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0016J,\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationService;", "", "notificationApiGatewayService", "Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "appService", "Lde/justsoftware/mobile/gateway/app/service/AppService;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;Lde/justsoftware/mobile/gateway/app/service/AppService;Ljava/time/Clock;)V", "getNotifications", "", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "status", "", "limit", "", "before", "getNotification", "notificationId", "archiveAllNotifications", "archiveNotification", "", "openNotifications", "notificationIds", "markNotification", "action", "registerAndroid", "Lde/justsoftware/mobile/gateway/notification/model/PushToken;", "pushToken", "publicKey", "mobilePlatformVersion", "registerIos", "silenceAlerts", "", "unregisterPushToken", "mobilePlatform", "getChanges", "Lde/justsoftware/mobile/gateway/notification/model/ChangeList;", "token", "mobile-gateway"})
public class NotificationService {
    @NotNull
    private final NotificationApiGatewayService notificationApiGatewayService;
    @NotNull
    private final AppService appService;
    @NotNull
    private final Clock clock;

    public NotificationService(@NotNull NotificationApiGatewayService notificationApiGatewayService, @NotNull AppService appService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)notificationApiGatewayService, (String)"notificationApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)appService, (String)"appService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.notificationApiGatewayService = notificationApiGatewayService;
        this.appService = appService;
        this.clock = clock;
    }

    @NotNull
    public List<Notification> getNotifications(@NotNull String status, int limit, @NotNull String before) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        return this.notificationApiGatewayService.getNotifications(status, limit, before);
    }

    @NotNull
    public Notification getNotification(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        return this.notificationApiGatewayService.getNotification(notificationId);
    }

    @NotNull
    public List<String> archiveAllNotifications() {
        return this.notificationApiGatewayService.archiveAllNotifications();
    }

    public void archiveNotification(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        this.notificationApiGatewayService.archiveNotification(notificationId);
    }

    public void openNotifications(@NotNull List<String> notificationIds) {
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        this.notificationApiGatewayService.openNotifications(notificationIds);
    }

    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.notificationApiGatewayService.markNotification(notificationId, action);
    }

    @NotNull
    public PushToken registerAndroid(@NotNull String pushToken, @Nullable String publicKey, @Nullable String mobilePlatformVersion) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        return this.notificationApiGatewayService.registerAndroid(pushToken, publicKey, mobilePlatformVersion);
    }

    @NotNull
    public PushToken registerIos(@NotNull String pushToken, @Nullable String publicKey, boolean silenceAlerts, @Nullable String mobilePlatformVersion) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        return this.notificationApiGatewayService.registerIos(pushToken, publicKey, silenceAlerts, mobilePlatformVersion);
    }

    public void unregisterPushToken(@NotNull String mobilePlatform, @NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        this.notificationApiGatewayService.unregisterPushToken(mobilePlatform, pushToken);
    }

    @NotNull
    public ChangeList getChanges(@Nullable String token) {
        NotificationSyncToken syncToken = NotificationSyncToken.Companion.decode(token);
        Instant now = this.clock.instant();
        if (syncToken != null) {
            Intrinsics.checkNotNull((Object)now);
            if (NotificationSyncToken.Companion.maySkipAppThemes(syncToken, now)) {
                return ApiChangeList.Companion.toChangeList$default((ApiChangeList.Companion)ApiChangeList.Companion, (ApiChangeList)this.notificationApiGatewayService.getChanges(syncToken.getApiSyncToken()), (Instant)syncToken.getIncludedAppThemesAt(), null, (int)2, null);
            }
        }
        return (ChangeList)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    public static final /* synthetic */ NotificationApiGatewayService access$getNotificationApiGatewayService$p(NotificationService $this) {
        return $this.notificationApiGatewayService;
    }

    public static final /* synthetic */ AppService access$getAppService$p(NotificationService $this) {
        return $this.appService;
    }
}

