/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import de.justsoftware.justimport.util.ImportResult;
import java.util.Iterator;

public class ImportResult {
    private static final String STATISTICS_TEMPLATE = "%sx %s%n";
    private final Multiset<ErrorReasons> _errorReasonStatistics = HashMultiset.create((int)ErrorReasons.values().length);
    private final Multiset<ReasonsForSkip> _reasonForSkipStatistics = HashMultiset.create((int)ReasonsForSkip.values().length);
    private int _members;
    private int _groupsInserted;
    private int _groupsUpdated;

    public int getSuccessfulMembers() {
        return this._members;
    }

    public void increaseInsertedGroups() {
        ++this._groupsInserted;
    }

    public void increaseUpdatedGroups() {
        ++this._groupsUpdated;
    }

    public int getSuccessfulGroups() {
        return this._groupsInserted + this._groupsUpdated;
    }

    public int getInsertedGroups() {
        return this._groupsInserted;
    }

    public int getUpdatedGroups() {
        return this._groupsUpdated;
    }

    public ImmutableMultiset<ErrorReasons> getErrors() {
        return ImmutableMultiset.copyOf((Iterator)this._errorReasonStatistics.iterator());
    }

    public ImmutableMultiset<ReasonsForSkip> getReasonsForSkipping() {
        return ImmutableMultiset.copyOf((Iterator)this._reasonForSkipStatistics.iterator());
    }

    public void increaseMembers() {
        ++this._members;
    }

    public void increaseFailed(ErrorReasons reason) {
        this._errorReasonStatistics.add((Object)reason);
    }

    public void increaseSkipped(ReasonsForSkip reason) {
        this._reasonForSkipStatistics.add((Object)reason);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String summary = String.format("Import statistics: Groups (%s successful, %s inserted, %s updated), Members (%s successful).%n", this.getSuccessfulGroups(), this.getInsertedGroups(), this.getUpdatedGroups(), this.getSuccessfulMembers());
        builder.append(summary);
        if (this.getReasonsForSkipping().isEmpty()) {
            builder.append(String.format("No entries skipped.", new Object[0]));
        } else {
            builder.append(String.format("Statistics for skipped:%n", new Object[0]));
            this.getReasonsForSkipping().forEachEntry((reason, occurrences) -> builder.append(String.format(STATISTICS_TEMPLATE, occurrences, reason.name())));
        }
        if (this.getErrors().isEmpty()) {
            builder.append(String.format("No errors.", new Object[0]));
        } else {
            builder.append(String.format("Statistics for errors:%n", new Object[0]));
            this.getErrors().forEachEntry((reason, occurrences) -> builder.append(String.format(STATISTICS_TEMPLATE, occurrences, reason.name())));
        }
        return builder.toString();
    }
}

