/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

@Embeddable
public class DbUserGroupMemberId
implements Serializable {
    private static final long serialVersionUID = -191126362676372530L;
    @Column(nullable=false)
    private UUID profileId;
    @Column(nullable=false)
    private UUID userGroupId;

    public DbUserGroupMemberId() {
    }

    public DbUserGroupMemberId(UUID profileId, UUID userGroupId) {
        this.profileId = profileId;
        this.userGroupId = userGroupId;
    }

    public DbUserGroupMemberId(UUID profileId, UserGroupId userGroupId) {
        this(profileId, (UUID)userGroupId.getId());
    }

    public UUID getProfileId() {
        return this.profileId;
    }

    public UUID getUserGroupId() {
        return this.userGroupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbUserGroupMemberId that = (DbUserGroupMemberId)o;
        return Objects.equals(this.profileId, that.profileId) && Objects.equals(this.userGroupId, that.userGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.profileId, this.userGroupId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("profileId", (Object)this.profileId).add("userGroupId", (Object)this.userGroupId).toString();
    }
}

