/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.persistence.model.DbUserGroup;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import java.time.Instant;
import java.util.UUID;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullUnmarked
public class DbUserGroupBuilder {
    private UUID _id = UUID.randomUUID();
    private UUID _tenantId = UUID.randomUUID();
    private String _name;
    private boolean _isAllTenantUsersGroup = false;
    private Instant _importedAt;
    private ImportMethod _importMethod;

    public DbUserGroupBuilder from(DbUserGroup group) {
        this._id = group.getId();
        this._tenantId = group.getTenantId();
        this._name = group.getName();
        this._isAllTenantUsersGroup = group.isAllTenantUsersGroup();
        this._importedAt = group.getImportedAt();
        this._importMethod = group.getImportMethod();
        return this;
    }

    public DbUserGroupBuilder setId(UUID id) {
        this._id = id;
        return this;
    }

    public DbUserGroupBuilder setTenantId(UUID tenantId) {
        this._tenantId = tenantId;
        return this;
    }

    public DbUserGroupBuilder setTenantId(TenantId tenantId) {
        this._tenantId = (UUID)tenantId.getId();
        return this;
    }

    public DbUserGroupBuilder setName(String name) {
        this._name = name;
        return this;
    }

    public DbUserGroupBuilder setIsAllTenantUsersGroup(boolean isAllUsersGroup) {
        this._isAllTenantUsersGroup = isAllUsersGroup;
        return this;
    }

    public DbUserGroupBuilder setImportedAt(@Nullable Instant importedAt) {
        this._importedAt = importedAt;
        return this;
    }

    public DbUserGroupBuilder setImportMethod(@Nullable ImportMethod importMethod) {
        this._importMethod = importMethod;
        return this;
    }

    public DbUserGroup build() {
        return new DbUserGroup(this._id, this._name, this._tenantId, this._isAllTenantUsersGroup, this._importedAt, this._importMethod);
    }
}

