/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence;

import de.justsoftware.justimport.domain.model.common.AbstractId;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.justimport.persistence.model.DbExternalIdMapping;
import de.justsoftware.justimport.persistence.model.DbExternalIdMappingId;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@org.springframework.stereotype.Repository
@Table(name="ExternalIdMapping")
public interface ExternalIdMappingRepository
extends Repository<DbExternalIdMapping, DbExternalIdMappingId> {
    default public void store(ExternalIdMapping mapping) {
        this.store(List.of(mapping));
    }

    @Transactional
    default public void store(List<ExternalIdMapping> mappings) {
        Set<DbExternalIdMapping> dboMappings = mappings.stream().map(ExternalIdMapping::toDbObject).collect(Collectors.toSet());
        dboMappings.forEach(arg_0 -> this.insert(arg_0));
        dboMappings.forEach(arg_0 -> this.update(arg_0));
    }

    @Deprecated
    @Query(value="SELECT mapping FROM DbExternalIdMapping mapping")
    public List<DbExternalIdMapping> findAllEntries();

    default public List<ExternalIdMapping> findAll() {
        return this.findAllEntries().stream().map(DbExternalIdMapping::toDto).collect(Collectors.toList());
    }

    @Modifying
    @Query(value="    INSERT INTO DbExternalIdMapping (tenantId, externalSystem, internalId, externalId)\n    SELECT :#{#mapping.tenantId}, :#{#mapping.externalSystem}, :#{#mapping.internalId}, :#{#mapping.externalId}\n    WHERE NOT EXISTS (SELECT 1 FROM DbExternalIdMapping m\n        WHERE m.tenantId = :#{#mapping.tenantId} and m.externalSystem = :#{#mapping.externalSystem}\n        AND (m.internalId = :#{#mapping.internalId} OR m.externalId = :#{#mapping.externalId}))\n")
    public void insert(@Param(value="mapping") DbExternalIdMapping var1);

    @Modifying
    @Query(value="    UPDATE DbExternalIdMapping m\n    SET m.externalId = :#{#mapping.externalId}, m.internalId = :#{#mapping.internalId}\n    WHERE m.tenantId = :#{#mapping.tenantId} AND m.externalSystem = :#{#mapping.externalSystem}\n        AND (m.internalId = :#{#mapping.internalId} OR m.externalId = :#{#mapping.externalId})\n")
    public void update(@Param(value="mapping") DbExternalIdMapping var1);

    default public Optional<ExternalIdMapping> getByExternalId(TenantId tenantId, ExternalSystemId systemId, ExternalId externalId) {
        return Optional.ofNullable((ExternalIdMapping)this.getByExternalId(tenantId, systemId, Set.of(externalId)).get(externalId));
    }

    @Deprecated
    public Set<DbExternalIdMapping> findAllByTenantIdAndExternalSystemAndExternalIdIn(UUID var1, String var2, Set<String> var3);

    default public Map<ExternalId, ExternalIdMapping> getByExternalId(TenantId tenantId, ExternalSystemId systemId, Set<ExternalId> externalIds) {
        Set stringIds = externalIds.stream().map(AbstractId::asString).collect(Collectors.toSet());
        return this.findAllByTenantIdAndExternalSystemAndExternalIdIn((UUID)tenantId.getId(), (String)systemId.getId(), stringIds).stream().map(DbExternalIdMapping::toDto).filter(mapping -> externalIds.stream().anyMatch(id -> id.equals((Object)mapping.getExternalId()))).collect(Collectors.toMap(ExternalIdMapping::getExternalId, Function.identity()));
    }

    @Deprecated
    public Set<DbExternalIdMapping> deleteByInternalIdIn(Set<String> var1);

    @Deprecated
    public Set<DbExternalIdMapping> deleteByTenantIdAndExternalSystemAndInternalIdIn(UUID var1, String var2, Set<String> var3);

    @Transactional
    default public Set<DbExternalIdMapping> deleteAllForInternalIds(Set<? extends InternalId> toDelete) {
        Set stringIds = toDelete.stream().map(InternalId::asString).collect(Collectors.toSet());
        return toDelete.isEmpty() ? Set.of() : this.deleteByInternalIdIn(stringIds);
    }

    @Transactional
    default public Set<ExternalIdMapping> deleteAllForInternalIds(TenantId tenantId, ExternalSystemId systemId, Set<? extends InternalId> toDelete) {
        if (toDelete.isEmpty()) {
            return Set.of();
        }
        Set internalIdStrings = toDelete.stream().map(InternalId::asString).collect(Collectors.toSet());
        Set deleted = this.deleteByTenantIdAndExternalSystemAndInternalIdIn((UUID)tenantId.getId(), (String)systemId.getId(), internalIdStrings);
        return deleted.stream().map(DbExternalIdMapping::toDto).collect(Collectors.toSet());
    }
}

