/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.kafka.impl;

import com.google.common.base.Strings;
import de.justsoftware.justimport.kafka.KafkaConfigurationProvider;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"liquibase"})
public class KafkaConfigurationProviderImpl
implements KafkaConfigurationProvider {
    private static final Integer KAFKA_PRODUCER_BUFFER_MEMORY = 0x2000000;
    private static final Integer KAFKA_PRODUCER_BATCH_SIZE = 16384;
    private final @Nullable String _bootstrapServers;
    private final int _maxChunkSize;
    private final boolean _kafkaEnabled;

    @Autowired
    public KafkaConfigurationProviderImpl(@Value(value="${just.import.kafka.bootstrapServers:}") @Nullable String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize, @Value(value="${kafka.enabled:true}") boolean kafkaEnabled) {
        this._bootstrapServers = bootstrapServers;
        this._maxChunkSize = maxChunkSize;
        this._kafkaEnabled = kafkaEnabled;
    }

    private @Nullable Properties consumerConfig(@Nullable String groupid, int maxChunkSize) {
        if (Strings.isNullOrEmpty((String)this._bootstrapServers)) {
            return null;
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", "earliest");
        props.put("max.poll.records", (Object)maxChunkSize);
        if (groupid != null) {
            props.put("group.id", groupid);
        }
        return props;
    }

    public @Nullable Properties consumerConfig(@Nullable String groupId) {
        return this.consumerConfig(groupId, this._maxChunkSize);
    }

    public Properties producerConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", KAFKA_PRODUCER_BATCH_SIZE);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", KAFKA_PRODUCER_BUFFER_MEMORY);
        return props;
    }

    public @Nullable Consumer<String, String> stringConsumer() {
        return this.consumer(null, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), this._maxChunkSize);
    }

    public @Nullable Consumer<String, String> stringConsumer(@Nullable String groupId) {
        return this.consumer(groupId, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), this._maxChunkSize);
    }

    public @Nullable Consumer<String, String> stringConsumer(String groupId, int maxChunkSize) {
        return this.consumer(groupId, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), maxChunkSize);
    }

    private <K, V> @Nullable Consumer<K, V> consumer(@Nullable String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxChunkSize) {
        Properties config = this.consumerConfig(groupId, maxChunkSize);
        if (config == null) {
            return null;
        }
        return new KafkaConsumer(config, keyDeserializer, valueDeserializer);
    }

    public boolean isKafkaEnabled() {
        return this._kafkaEnabled;
    }
}

