/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.usergroup.ldap;

import de.justsoftware.justimport.business.UserGroupImportConfig;
import de.justsoftware.justimport.domain.usergroup.ldap.LdapUserGroup;
import java.util.Objects;
import javax.naming.Name;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.Nullable;
import org.springframework.LdapDataEntry;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.odm.core.impl.DefaultObjectDirectoryMapper;
import org.springframework.stereotype.Service;

@Service
public class LdapUserGroupObjectDirectoryMapper
implements ObjectDirectoryMapper {
    private final DefaultObjectDirectoryMapper _delegate = new DefaultObjectDirectoryMapper();
    private final @Nullable String _customNameAttribute;

    public LdapUserGroupObjectDirectoryMapper(UserGroupImportConfig userGroupImportConfig) {
        this._customNameAttribute = userGroupImportConfig.getUserGroupNameAttribute();
    }

    public void mapToLdapDataEntry(Object entry, LdapDataEntry context) {
        this._delegate.mapToLdapDataEntry(entry, context);
    }

    public <T> T mapFromLdapDataEntry(LdapDataEntry ctx, Class<T> clazz) {
        Object mapped = this._delegate.mapFromLdapDataEntry(ctx, clazz);
        if (mapped instanceof LdapUserGroup) {
            LdapUserGroup group = (LdapUserGroup)mapped;
            String customName = this._customNameAttribute != null ? ctx.getStringAttribute(this._customNameAttribute) : null;
            String name = Objects.requireNonNullElseGet(customName, () -> group.getDescription() != null ? group.getDescription() : Objects.requireNonNullElse(group.getCn(), "NO NAME IN LDAP"));
            group.setName(name);
        }
        return (T)mapped;
    }

    public Name getId(Object entry) {
        return this._delegate.getId(entry);
    }

    public void setId(Object entry, Name id) {
        this._delegate.setId(entry, id);
    }

    public Name getCalculatedId(Object entry) {
        return this._delegate.getCalculatedId(entry);
    }

    public Filter filterFor(Class<?> clazz, Filter baseFilter) {
        return this._delegate.filterFor(clazz, baseFilter);
    }

    public String attributeFor(Class<?> clazz, String fieldName) {
        return this._delegate.attributeFor(clazz, fieldName);
    }

    public String[] manageClass(Class<?> clazz) {
        if (!clazz.equals(LdapUserGroup.class)) {
            return this._delegate.manageClass(clazz);
        }
        Object[] managedAttributes = this._delegate.manageClass(clazz);
        return this._customNameAttribute != null ? (String[])ArrayUtils.addAll((Object[])managedAttributes, (Object[])new String[]{this._customNameAttribute}) : managedAttributes;
    }
}

