/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.profile.ldap;

import com.google.common.collect.Streams;
import de.justsoftware.justimport.business.ProfileImportConfig;
import de.justsoftware.justimport.domain.JustLdapUtils;
import de.justsoftware.justimport.domain.impl.profile.ldap.DomainResolver;
import de.justsoftware.justimport.domain.model.common.ExternalIdField;
import de.justsoftware.justimport.domain.model.common.LDAPExternalIdUtil;
import de.justsoftware.justimport.domain.profile.ldap.LdapProfile;
import de.justsoftware.justimport.domain.profile.ldap.LdapProfileRepository;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Optionals;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.stereotype.Repository;

@Repository
public class LdapProfileRepositoryImpl
implements LdapProfileRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LdapProfileRepositoryImpl.class);
    private static final String USER_ATTRIBUTES_WILDCARD = "*";
    private final LdapTemplate _ldapTemplate;
    private final DomainResolver _domainResolver;
    private final ContextMapper<LdapProfile> _contextMapper;
    private final LdapName _ldapBase;

    @Autowired
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="we want exception to be thrown")
    public LdapProfileRepositoryImpl(LdapTemplate ldapTemplate, ProfileImportConfig profileImportConfig) {
        this._ldapTemplate = ldapTemplate;
        this._domainResolver = new DomainResolver(profileImportConfig.getDefaultDomain());
        this._ldapBase = JustLdapUtils.determineLdapBase((LdapTemplate)this._ldapTemplate);
        this._contextMapper = ctx -> {
            DirContextAdapter context = (DirContextAdapter)ctx;
            String externalId = LDAPExternalIdUtil.getExternalIdAsString((DirContextOperations)context, (ExternalIdField)new ExternalIdField(profileImportConfig.getExternalIdAttribute(), profileImportConfig.getExternalIdIsGUID()));
            if (externalId == null) {
                LOG.warn("Could not determine an externalId for the dn: {}", (Object)context.getDn());
                return null;
            }
            return new LdapProfile(context.getDn(), externalId, this._domainResolver.getDomain(this._ldapBase.isEmpty() ? context.getDn() : this._ldapBase));
        };
    }

    public @Nullable LdapProfile findByDN(Name dn, String externalIdAttributeName) throws NamingException {
        String[] selectAttributes = new String[]{USER_ATTRIBUTES_WILDCARD, externalIdAttributeName};
        return (LdapProfile)this._ldapTemplate.lookup((Name)LdapUtils.removeFirst((Name)dn, (Name)this._ldapBase), selectAttributes, this._contextMapper);
    }

    public Optional<LdapProfile> findById(Name name, String externalIdAttributeName) {
        try {
            LOG.debug("findById: {} - {}", (Object)name, (Object)externalIdAttributeName);
            return Optional.ofNullable(this.findByDN(name, externalIdAttributeName));
        }
        catch (NameNotFoundException e) {
            LOG.info("Name not found: {}", (Object)name);
        }
        catch (NamingException e) {
            LOG.error("Could not process ldap profile for name: {}", (Object)name, (Object)e);
        }
        return Optional.empty();
    }

    public List<LdapProfile> findAllById(Iterable<Name> names, String externalIdAttributeName) {
        return Streams.stream(names).map(name -> this.findById(name, externalIdAttributeName)).flatMap(xva$0 -> Optionals.toStream((Optional[])new Optional[]{xva$0})).collect(Collectors.toList());
    }
}

