/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.profile.ldap;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.jspecify.annotations.Nullable;

public class DomainResolver {
    private static final Joiner JOINER = Joiner.on((char)'.').skipNulls();
    private final @Nullable String _defaultDomain;

    public DomainResolver(@Nullable String defaultDomain) {
        this._defaultDomain = Strings.emptyToNull((String)defaultDomain);
    }

    public String getDomain(Name distinguishedName) throws InvalidNameException {
        if (this._defaultDomain != null) {
            return this._defaultDomain;
        }
        LdapName dn = distinguishedName instanceof LdapName ? (LdapName)distinguishedName : new LdapName(distinguishedName.toString());
        ImmutableList domain = (ImmutableList)dn.getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase("dc")).map(Rdn::getValue).map(Rdn::escapeValue).collect(ImmutableList.toImmutableList());
        if (!domain.isEmpty()) {
            return JOINER.join((Iterable)Lists.reverse((List)domain));
        }
        throw new InvalidNameException("Failed to extract domain from dn: No domain part found in dn " + String.valueOf(distinguishedName));
    }
}

